/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.facilities;

import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Coord;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Network;
import org.matsim.api.core.v01.population.Activity;
import org.matsim.core.gbl.Gbl;
import org.matsim.core.network.NetworkUtils;
import org.matsim.core.router.LinkWrapperFacility;
import org.matsim.facilities.ActivityFacilities;
import org.matsim.facilities.ActivityFacilitiesImpl;
import org.matsim.facilities.ActivityFacility;
import org.matsim.facilities.ActivityFacilityImpl;
import org.matsim.facilities.ActivityWrapperFacility;
import org.matsim.facilities.Facility;

public class FacilitiesUtils {
    private static final Logger log = Logger.getLogger(FacilitiesUtils.class);

    private FacilitiesUtils() {
    }

    public static ActivityFacilities createActivityFacilities() {
        return FacilitiesUtils.createActivityFacilities(null);
    }

    public static ActivityFacilities createActivityFacilities(String name) {
        return new ActivityFacilitiesImpl(name);
    }

    public static SortedMap<Id<ActivityFacility>, ActivityFacility> getSortedFacilities(ActivityFacilities facilities) {
        return new TreeMap<Id<ActivityFacility>, ActivityFacility>(facilities.getFacilities());
    }

    public static void setLinkID(Facility facility, Id<Link> linkId) {
        if (!(facility instanceof ActivityFacilityImpl)) {
            throw new RuntimeException("cannot set linkID for this facility type; API needs to be cleaned up");
        }
        ((ActivityFacilityImpl)facility).setLinkId(linkId);
    }

    public static Link decideOnLink(Facility facility, Network network) {
        Link accessActLink = null;
        Id<Link> accessActLinkId = null;
        try {
            accessActLinkId = facility.getLinkId();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (accessActLinkId != null) {
            accessActLink = network.getLinks().get(facility.getLinkId());
        }
        if (accessActLink == null) {
            if (facility.getCoord() == null) {
                throw new RuntimeException("link for facility cannot be determined when neither facility link id nor facility coordinate given");
            }
            accessActLink = NetworkUtils.getNearestLink(network, facility.getCoord());
            if (accessActLink == null) {
                int ii = 0;
                for (Link link : network.getLinks().values()) {
                    if (ii == 10) break;
                    ++ii;
                    log.warn(link);
                }
            }
            Gbl.assertNotNull(accessActLink);
        }
        return accessActLink;
    }

    public static Facility toFacility(Activity toWrap, ActivityFacilities activityFacilities) {
        ActivityFacility fac;
        if (activityFacilities != null && toWrap.getFacilityId() != null && (fac = activityFacilities.getFacilities().get(toWrap.getFacilityId())) != null) {
            return fac;
        }
        return new ActivityWrapperFacility(toWrap);
    }

    public static Facility wrapActivity(Activity toWrap) {
        return new ActivityWrapperFacility(toWrap);
    }

    public static Facility wrapLink(Link link) {
        return new LinkWrapperFacility(link);
    }

    public static Coord decideOnCoord(Facility facility, Network network) {
        Coord coord = facility.getCoord();
        if (coord == null) {
            coord = network.getLinks().get(facility.getLinkId()).getCoord();
        }
        return coord;
    }
}

