/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.facilities;

import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.matsim.core.api.internal.MatsimWriter;
import org.matsim.core.utils.geometry.CoordinateTransformation;
import org.matsim.core.utils.geometry.transformations.IdentityTransformation;
import org.matsim.facilities.ActivityFacilities;
import org.matsim.facilities.FacilitiesWriterV1;
import org.matsim.utils.objectattributes.AttributeConverter;

public class FacilitiesWriter
implements MatsimWriter {
    private final ActivityFacilities facilities;
    private final CoordinateTransformation coordinateTransformation;
    private Map<Class<?>, AttributeConverter<?>> converters = new HashMap();

    public FacilitiesWriter(ActivityFacilities facilities) {
        this(new IdentityTransformation(), facilities);
    }

    public FacilitiesWriter(CoordinateTransformation coordinateTransformation, ActivityFacilities facilities) {
        this.coordinateTransformation = coordinateTransformation;
        this.facilities = facilities;
    }

    @Override
    public final void write(String filename) {
        this.writeV1(filename);
    }

    public final void write(OutputStream stream) {
        FacilitiesWriterV1 writer = new FacilitiesWriterV1(this.coordinateTransformation, this.facilities);
        writer.putAttributeConverters(this.converters);
        writer.write(stream);
    }

    public void putAttributeConverters(Map<Class<?>, AttributeConverter<?>> converters) {
        this.converters.putAll(converters);
    }

    public void putAttributeConverter(Class<?> key, AttributeConverter<?> converter) {
        this.converters.put(key, converter);
    }

    public final void writeV1(String filename) {
        FacilitiesWriterV1 writer = new FacilitiesWriterV1(this.coordinateTransformation, this.facilities);
        writer.putAttributeConverters(this.converters);
        writer.write(filename);
    }
}

