/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.facilities;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.SortedSet;
import org.matsim.api.core.v01.Coord;
import org.matsim.core.api.internal.MatsimWriter;
import org.matsim.core.utils.collections.Tuple;
import org.matsim.core.utils.geometry.CoordinateTransformation;
import org.matsim.core.utils.io.MatsimXmlWriter;
import org.matsim.core.utils.misc.Time;
import org.matsim.facilities.ActivityFacilities;
import org.matsim.facilities.ActivityFacility;
import org.matsim.facilities.ActivityFacilityImpl;
import org.matsim.facilities.ActivityOption;
import org.matsim.facilities.ActivityOptionImpl;
import org.matsim.facilities.FacilitiesUtils;
import org.matsim.facilities.OpeningTime;
import org.matsim.utils.objectattributes.AttributeConverter;
import org.matsim.utils.objectattributes.attributable.AttributesXmlWriterDelegate;

class FacilitiesWriterV1
extends MatsimXmlWriter
implements MatsimWriter {
    private static final String DTD = "http://www.matsim.org/files/dtd/facilities_v1.dtd";
    private final ActivityFacilities facilities;
    private final CoordinateTransformation coordinateTransformation;
    private AttributesXmlWriterDelegate attributesWriter = new AttributesXmlWriterDelegate();

    FacilitiesWriterV1(CoordinateTransformation coordinateTransformation, ActivityFacilities facilities) {
        this.coordinateTransformation = coordinateTransformation;
        this.facilities = facilities;
    }

    @Override
    public void write(String filename) {
        this.openFile(filename);
        this.writeInit();
        for (ActivityFacility f : FacilitiesUtils.getSortedFacilities(this.facilities).values()) {
            this.writeFacility((ActivityFacilityImpl)f);
        }
        this.writeFinish();
    }

    public void write(OutputStream stream) {
        this.openOutputStream(stream);
        this.writeInit();
        for (ActivityFacility f : FacilitiesUtils.getSortedFacilities(this.facilities).values()) {
            this.writeFacility((ActivityFacilityImpl)f);
        }
        this.writeFinish();
    }

    private void writeInit() {
        this.writeXmlHead();
        this.writeDoctype("facilities", DTD);
        this.startFacilities(this.facilities, this.writer);
    }

    private void writeFacility(ActivityFacilityImpl f) {
        try {
            this.startFacility(f);
            for (ActivityOption a : f.getActivityOptions().values()) {
                this.startActivity((ActivityOptionImpl)a);
                this.writeCapacity((ActivityOptionImpl)a, this.writer);
                SortedSet<OpeningTime> o_set = a.getOpeningTimes();
                for (OpeningTime o : o_set) {
                    this.writeOpentime(o, this.writer);
                }
                this.endActivity();
            }
            this.attributesWriter.writeAttributes("\t\t", this.writer, f.getAttributes());
            this.endFacility();
            this.writer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void writeFinish() {
        try {
            this.endFacilities();
            this.writer.flush();
            this.writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void startFacilities(ActivityFacilities facilities, BufferedWriter out) {
        ArrayList<Tuple<String, String>> attributes = new ArrayList<Tuple<String, String>>();
        if (facilities.getName() != null) {
            attributes.add(new Tuple<String, String>("name", facilities.getName()));
        }
        this.writeStartTag("facilities", attributes);
        this.attributesWriter.writeAttributes("\t", out, facilities.getAttributes());
    }

    private void endFacilities() {
        this.writeEndTag("facilities");
    }

    private void startFacility(ActivityFacilityImpl facility) {
        ArrayList<Tuple<String, String>> attributes = new ArrayList<Tuple<String, String>>();
        attributes.add(new Tuple<String, String>("id", facility.getId().toString()));
        if (facility.getLinkId() != null) {
            attributes.add(new Tuple<String, String>("linkId", facility.getLinkId().toString()));
        }
        if (facility.getCoord() != null) {
            Coord coord = this.coordinateTransformation.transform(facility.getCoord());
            attributes.add(new Tuple<String, String>("x", Double.toString(coord.getX())));
            attributes.add(new Tuple<String, String>("y", Double.toString(coord.getY())));
        }
        if (facility.getDesc() != null) {
            attributes.add(new Tuple<String, String>("desc", facility.getDesc()));
        }
        this.writeStartTag("facility", attributes, false);
    }

    private void endFacility() {
        this.writeEndTag("facility");
    }

    public void startActivity(ActivityOptionImpl activity) {
        ArrayList<Tuple<String, String>> attributes = new ArrayList<Tuple<String, String>>();
        attributes.add(new Tuple<String, String>("type", activity.getType()));
        this.writeStartTag("activity", attributes);
    }

    public void endActivity() {
        this.writeEndTag("activity");
    }

    private void writeCapacity(ActivityOptionImpl activity, BufferedWriter out) throws IOException {
        if (activity.getCapacity() != 2.147483647E9) {
            out.write("\t\t\t<capacity");
            out.write(" value=\"" + activity.getCapacity() + "\"");
            out.write(" />\n");
        }
    }

    private void writeOpentime(OpeningTime opentime, BufferedWriter out) throws IOException {
        out.write("\t\t\t<opentime");
        out.write(" day=\"wkday\"");
        out.write(" start_time=\"" + Time.writeTime(opentime.getStartTime()) + "\"");
        out.write(" end_time=\"" + Time.writeTime(opentime.getEndTime()) + "\"");
        out.write(" />\n");
    }

    public void putAttributeConverters(Map<Class<?>, AttributeConverter<?>> converters) {
        this.attributesWriter.putAttributeConverters(converters);
    }
}

