/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.facilities;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Scenario;
import org.matsim.core.utils.geometry.CoordinateTransformation;
import org.matsim.core.utils.io.MatsimXmlParser;
import org.matsim.facilities.ActivityFacilities;
import org.matsim.facilities.FacilitiesReaderMatsimV1;
import org.matsim.utils.objectattributes.AttributeConverter;
import org.xml.sax.Attributes;

public class MatsimFacilitiesReader
extends MatsimXmlParser {
    private static final String FACILITIES_V1 = "facilities_v1.dtd";
    private static final Logger log = Logger.getLogger(MatsimFacilitiesReader.class);
    private final String externalInputCRS;
    private final String targetCRS;
    private CoordinateTransformation coordinateTransformation;
    private final ActivityFacilities facilities;
    private MatsimXmlParser delegate = null;
    private Map<Class<?>, AttributeConverter<?>> attributeConverters = new HashMap();

    public MatsimFacilitiesReader(Scenario scenario) {
        this(null, scenario);
    }

    public MatsimFacilitiesReader(String targetCRS, Scenario scenario) {
        this(scenario.getConfig().facilities().getInputCRS(), targetCRS, scenario.getActivityFacilities());
    }

    public MatsimFacilitiesReader(String externalInputCRS, String targetCRS, ActivityFacilities facilities) {
        this.externalInputCRS = externalInputCRS;
        this.targetCRS = targetCRS;
        this.facilities = facilities;
    }

    public void putAttributeConverter(Class<?> clazz, AttributeConverter<?> converter) {
        this.attributeConverters.put(clazz, converter);
    }

    public void putAttributeConverters(Map<Class<?>, AttributeConverter<?>> converters) {
        this.attributeConverters.putAll(converters);
    }

    @Override
    public void startTag(String name, Attributes atts, Stack<String> context) {
        this.delegate.startTag(name, atts, context);
    }

    @Override
    public void endTag(String name, String content, Stack<String> context) {
        this.delegate.endTag(name, content, context);
    }

    @Override
    protected void setDoctype(String doctype) {
        super.setDoctype(doctype);
        if (!FACILITIES_V1.equals(doctype)) {
            throw new IllegalArgumentException("Doctype \"" + doctype + "\" not known.");
        }
        this.delegate = new FacilitiesReaderMatsimV1(this.externalInputCRS, this.targetCRS, this.facilities);
        ((FacilitiesReaderMatsimV1)this.delegate).putAttributeConverters(this.attributeConverters);
        log.info("using facilities_v1-reader.");
    }
}

