/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.facilities;

import org.matsim.core.utils.misc.Time;
import org.matsim.facilities.OpeningTime;

public class OpeningTimeImpl
implements OpeningTime {
    private double startTime;
    private double endTime;

    public OpeningTimeImpl(double startTime, double endTime) {
        this.startTime = startTime;
        this.endTime = endTime;
        this.validateTimes();
    }

    @Override
    public int compareTo(OpeningTime other) {
        if (this.startTime > other.getEndTime()) {
            return -6;
        }
        if (this.startTime == other.getEndTime()) {
            return -5;
        }
        if (this.startTime > other.getStartTime()) {
            if (this.endTime > other.getEndTime()) {
                return -4;
            }
            if (this.endTime == other.getEndTime()) {
                return -3;
            }
            return -2;
        }
        if (this.startTime == other.getStartTime()) {
            if (this.endTime > other.getEndTime()) {
                return -1;
            }
            if (this.endTime == other.getEndTime()) {
                return 0;
            }
            return 3;
        }
        if (this.endTime > other.getEndTime()) {
            return 2;
        }
        if (this.endTime == other.getEndTime()) {
            return 1;
        }
        if (this.endTime > other.getStartTime()) {
            return 4;
        }
        if (this.endTime == other.getStartTime()) {
            return 5;
        }
        return 6;
    }

    public final boolean equals(Object o) {
        if (o instanceof OpeningTimeImpl) {
            OpeningTimeImpl other = (OpeningTimeImpl)o;
            if (other.startTime == this.startTime && other.endTime == this.endTime) {
                return true;
            }
        }
        return false;
    }

    public final int hashCode() {
        return Double.valueOf(this.startTime).hashCode() + Double.valueOf(this.endTime).hashCode();
    }

    private final void validateTimes() {
        if (this.startTime != Double.NEGATIVE_INFINITY && this.endTime != Double.NEGATIVE_INFINITY && this.startTime >= this.endTime) {
            throw new RuntimeException(this + "[startTime=" + this.startTime + " >= endTime=" + this.endTime + " not allowed]");
        }
    }

    @Override
    public final void setStartTime(double start_time) {
        this.startTime = start_time;
        this.validateTimes();
    }

    @Override
    public final void setEndTime(double end_time) {
        this.endTime = end_time;
        this.validateTimes();
    }

    @Override
    public final double getStartTime() {
        return this.startTime;
    }

    @Override
    public final double getEndTime() {
        return this.endTime;
    }

    public final String toString() {
        return "[startTime=" + Time.writeTime(this.startTime) + "]" + "[endTime=" + Time.writeTime(this.endTime) + "]";
    }

    public static enum TimeRelation {
        START_AND_END_BEFORE,
        START_AND_END_AFTER,
        START_AND_END_WITHIN,
        START_BEFORE_END_WITHIN,
        START_WITHIN_END_AFTER,
        START_BEFORE_END_AFTER;

    }
}

