/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.facilities.algorithms;

import org.matsim.facilities.ActivityFacilities;
import org.matsim.facilities.ActivityFacility;
import org.matsim.facilities.ActivityOptionImpl;

public class FacilitiesSummary {
    public void run(ActivityFacilities facilities) {
        System.out.println("    running " + this.getClass().getName() + " algorithm...");
        int f_cnt = 0;
        int act_cnt = 0;
        double min_coordX = Double.POSITIVE_INFINITY;
        double min_coordY = Double.POSITIVE_INFINITY;
        double max_coordX = Double.NEGATIVE_INFINITY;
        double max_coordY = Double.NEGATIVE_INFINITY;
        int[] caps = new int[]{0, 0, 0, 0, 0};
        int unlimit_cap_cnt = 0;
        for (ActivityFacility activityFacility : facilities.getFacilities().values()) {
            ++f_cnt;
            if (activityFacility.getCoord().getX() > max_coordX) {
                max_coordX = activityFacility.getCoord().getX();
            }
            if (activityFacility.getCoord().getY() > max_coordY) {
                max_coordY = activityFacility.getCoord().getY();
            }
            if (activityFacility.getCoord().getX() < min_coordX) {
                min_coordX = activityFacility.getCoord().getX();
            }
            if (activityFacility.getCoord().getY() < min_coordY) {
                min_coordY = activityFacility.getCoord().getY();
            }
            for (ActivityOptionImpl activityOptionImpl : activityFacility.getActivityOptions().values()) {
                ++act_cnt;
                if (activityOptionImpl.getCapacity() != 2.147483647E9) {
                    if (activityOptionImpl.getType().equals("home")) {
                        caps[0] = (int)((double)caps[0] + activityOptionImpl.getCapacity());
                        continue;
                    }
                    if (activityOptionImpl.getType().equals("work")) {
                        caps[1] = (int)((double)caps[1] + activityOptionImpl.getCapacity());
                        continue;
                    }
                    if (activityOptionImpl.getType().equals("education")) {
                        caps[2] = (int)((double)caps[2] + activityOptionImpl.getCapacity());
                        continue;
                    }
                    if (activityOptionImpl.getType().equals("shop")) {
                        caps[3] = (int)((double)caps[3] + activityOptionImpl.getCapacity());
                        continue;
                    }
                    if (activityOptionImpl.getType().equals("leisure")) {
                        caps[4] = (int)((double)caps[4] + activityOptionImpl.getCapacity());
                        continue;
                    }
                    throw new RuntimeException("ERROR: in " + this.getClass().getName() + " in run(Facilities facilities):" + " do not know type = " + activityOptionImpl.getType());
                }
                ++unlimit_cap_cnt;
            }
        }
        System.out.println("      Number of Facilities:             " + f_cnt);
        System.out.println("      Number of Activities:             " + act_cnt);
        System.out.println("      Min Coord:                        " + min_coordX + " " + min_coordY);
        System.out.println("      Max Coord:                        " + max_coordX + " " + max_coordY);
        System.out.println("      total home cap:                   " + caps[0]);
        System.out.println("      total work cap:                   " + caps[1]);
        System.out.println("      total education cap:              " + caps[2]);
        System.out.println("      total shop cap:                   " + caps[3]);
        System.out.println("      total leisure cap:                " + caps[4]);
        System.out.println("      total acts with unlimited cap:    " + unlimit_cap_cnt);
        System.out.println("    done.");
    }
}

