/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.facilities.algorithms;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Network;
import org.matsim.core.config.Config;
import org.matsim.core.network.NetworkUtils;
import org.matsim.core.utils.io.IOUtils;
import org.matsim.facilities.ActivityFacilities;
import org.matsim.facilities.ActivityFacility;
import org.matsim.facilities.ActivityFacilityImpl;

public class WorldConnectLocations {
    private static final Logger log = Logger.getLogger(WorldConnectLocations.class);
    private final Config config;
    public static final String CONFIG_F2L = "f2l";
    public static final String CONFIG_F2L_INPUTF2LFile = "inputF2LFile";
    public static final String CONFIG_F2L_OUTPUTF2LFile = "outputF2LFile";

    public WorldConnectLocations(Config config) {
        this.config = config;
    }

    private final void connectByFile(ActivityFacilities facilities, Network network, String file, Set<Id<ActivityFacility>> remainingFacilities) {
        log.info("    connecting facilities with links via inputF2LFile=" + file);
        try (BufferedReader br = IOUtils.getBufferedReader(file);){
            String currLine;
            int lineCnt = 0;
            br.readLine();
            ++lineCnt;
            while ((currLine = br.readLine()) != null) {
                String[] entries = currLine.split("\t", -1);
                Id<ActivityFacility> fid = Id.create(entries[0].trim(), ActivityFacility.class);
                Id<Link> lid = Id.create(entries[1].trim(), Link.class);
                ActivityFacility f = facilities.getFacilities().get(fid);
                Link l = network.getLinks().get(lid);
                if (f != null && l != null) {
                    l = network.getLinks().get(l.getId());
                    this.mapFacilityToLink(f, l);
                    remainingFacilities.remove(f.getId());
                } else {
                    log.warn(lineCnt + ": at least one of the two locations not found.");
                }
                ++lineCnt;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error while reading given inputF2LFile='" + file + "'.", e);
        }
        log.info("      number of facilities that are still not connected to a link = " + remainingFacilities.size());
        log.info("    done. (connecting facilities with links via inputF2LFile=" + file + ")");
    }

    private void mapFacilityToLink(ActivityFacility f, Link l) {
        ((ActivityFacilityImpl)f).setLinkId(l.getId());
    }

    private final void writeF2LFile(ActivityFacilities facilities, String file) {
        log.info("    writing f<-->l connections to  outputF2LFile=" + file);
        try (BufferedWriter bw = IOUtils.getBufferedWriter(file);){
            bw.write("fid\tlid\n");
            for (ActivityFacility activityFacility : facilities.getFacilities().values()) {
                bw.write(activityFacility.getId().toString() + "\t" + activityFacility.getLinkId().toString() + "\n");
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error while writing given outputF2LFile='" + file + "'.", e);
        }
        log.info("    done. (writing f<-->l connections to  outputF2LFile=" + file + ")");
    }

    public final void connectFacilitiesWithLinks(ActivityFacilities facilities, Network network) {
        String outputF2LFile;
        Object inputF2LFile;
        log.info("  connecting facilities with links...");
        HashSet<Id<ActivityFacility>> remainingFacilities = new HashSet<Id<ActivityFacility>>(facilities.getFacilities().keySet());
        if (this.config != null && (inputF2LFile = this.config.findParam(CONFIG_F2L, CONFIG_F2L_INPUTF2LFile)) != null) {
            this.connectByFile(facilities, network, (String)inputF2LFile, remainingFacilities);
        }
        log.info("    connecting remaining facilities with links (" + remainingFacilities.size() + " remaining)...");
        for (Id id : remainingFacilities) {
            ActivityFacility f = facilities.getFacilities().get(id);
            Link l = NetworkUtils.getNearestRightEntryLink(network, f.getCoord());
            l = network.getLinks().get(l.getId());
            this.mapFacilityToLink(f, l);
        }
        log.info("    done.");
        if (this.config != null && (outputF2LFile = this.config.findParam(CONFIG_F2L, CONFIG_F2L_OUTPUTF2LFile)) != null) {
            this.writeF2LFile(facilities, outputF2LFile);
        }
        log.info("  done. (connecting facilities with links)");
    }
}

