/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.facilities.filters;

import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.matsim.facilities.ActivityFacility;
import org.matsim.facilities.algorithms.FacilityAlgorithm;
import org.matsim.facilities.filters.AbstractFacilityFilter;

public class FacilitiesActTypeFilter
extends AbstractFacilityFilter {
    private final Set<String> actTypePatterns = new TreeSet<String>();

    public FacilitiesActTypeFilter(FacilityAlgorithm nextAlgorithm) {
        this.nextAlgorithm = nextAlgorithm;
    }

    public void addActTypePattern(String actTypePattern) {
        this.actTypePatterns.add(actTypePattern);
    }

    @Override
    public boolean judge(ActivityFacility facility) {
        for (String activity : facility.getActivityOptions().keySet()) {
            for (String actTypePattern : this.actTypePatterns) {
                if (!Pattern.matches(actTypePattern, activity)) continue;
                return true;
            }
        }
        return false;
    }
}

