/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.households;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.population.Person;
import org.matsim.core.utils.io.MatsimXmlParser;
import org.matsim.core.utils.misc.Counter;
import org.matsim.households.Household;
import org.matsim.households.HouseholdImpl;
import org.matsim.households.Households;
import org.matsim.households.HouseholdsFactory;
import org.matsim.households.HouseholdsImpl;
import org.matsim.households.Income;
import org.matsim.utils.objectattributes.AttributeConverter;
import org.matsim.utils.objectattributes.attributable.Attributes;
import org.matsim.utils.objectattributes.attributable.AttributesXmlReaderDelegate;
import org.matsim.vehicles.Vehicle;

abstract class AbstractHouseholdsReaderV10
extends MatsimXmlParser {
    private List<Id<Person>> currentmembers = null;
    private Income currentincome = null;
    private HouseholdsFactory builder = null;
    private Id<Household> currentHhId = null;
    private List<Id<Vehicle>> currentVehicleIds = null;
    private Income.IncomePeriod currentIncomePeriod;
    private String currentincomeCurrency;
    private final Households households;
    private Counter counter = new Counter("  households # ");
    private Household currentHousehold = null;
    private final AttributesXmlReaderDelegate attributesReader = new AttributesXmlReaderDelegate();
    private Attributes currAttributes = new Attributes();

    public AbstractHouseholdsReaderV10(Households households) {
        if (households == null) {
            throw new IllegalArgumentException("Container for households must not be null!");
        }
        this.households = households;
        this.builder = households.getFactory();
    }

    public void putAttributeConverter(Class<?> clazz, AttributeConverter<?> converter) {
        this.attributesReader.putAttributeConverter(clazz, converter);
    }

    @Inject
    public void putAttributeConverters(Map<Class<?>, AttributeConverter<?>> converters) {
        this.attributesReader.putAttributeConverters(converters);
    }

    @Override
    public void endTag(String name, String content, Stack<String> context) {
        if ("household".equalsIgnoreCase(name)) {
            this.fillHousehold();
            ((HouseholdsImpl)this.households).addHousehold(this.currentHousehold);
            this.currentHousehold = null;
            this.counter.incCounter();
        } else if ("income".equalsIgnoreCase(name)) {
            this.currentincome = this.builder.createIncome(Double.parseDouble(content.trim()), this.currentIncomePeriod);
            this.currentincome.setCurrency(this.currentincomeCurrency);
        } else if ("households".equalsIgnoreCase(name)) {
            this.counter.printCounter();
        } else if (name.equalsIgnoreCase("attributes")) {
            this.currAttributes = null;
        } else if (name.equalsIgnoreCase("attribute")) {
            this.attributesReader.endTag(name, content, context);
        }
    }

    private void fillHousehold() {
        ((HouseholdImpl)this.currentHousehold).setMemberIds(this.currentmembers);
        ((HouseholdImpl)this.currentHousehold).setVehicleIds(this.currentVehicleIds);
        this.currentHousehold.setIncome(this.currentincome);
        this.currentHhId = null;
        this.currentVehicleIds = null;
        this.currentincome = null;
        this.currentmembers = null;
        this.currentIncomePeriod = null;
        this.currentincomeCurrency = null;
    }

    Household createHousehold() {
        Household hh = this.builder.createHousehold(this.currentHhId);
        ((HouseholdImpl)hh).setMemberIds(this.currentmembers);
        ((HouseholdImpl)hh).setVehicleIds(this.currentVehicleIds);
        hh.setIncome(this.currentincome);
        this.currentHhId = null;
        this.currentVehicleIds = null;
        this.currentincome = null;
        this.currentmembers = null;
        this.currentIncomePeriod = null;
        this.currentincomeCurrency = null;
        return hh;
    }

    @Override
    public void startTag(String name, org.xml.sax.Attributes atts, Stack<String> context) {
        if ("household".equalsIgnoreCase(name)) {
            this.currentHhId = Id.create(atts.getValue("id"), Household.class);
            this.currentHousehold = this.builder.createHousehold(this.currentHhId);
            this.currentmembers = new ArrayList<Id<Person>>();
            this.currentVehicleIds = new ArrayList<Id<Vehicle>>();
        } else if (!"members".equalsIgnoreCase(name)) {
            if ("personId".equalsIgnoreCase(name)) {
                Id<Person> personId = Id.create(atts.getValue("refId"), Person.class);
                this.currentmembers.add(personId);
            } else if ("income".equalsIgnoreCase(name)) {
                this.currentIncomePeriod = this.getIncomePeriod(atts.getValue("period"));
                this.currentincomeCurrency = atts.getValue("currency");
            } else if (!"vehicles".equalsIgnoreCase(name)) {
                if ("vehicleDefinitionId".equalsIgnoreCase(name)) {
                    Id<Vehicle> vehicleId = Id.create(atts.getValue("refId"), Vehicle.class);
                    this.currentVehicleIds.add(vehicleId);
                } else if (name.equalsIgnoreCase("attributes")) {
                    if (context.peek().equalsIgnoreCase("household")) {
                        this.currAttributes = this.currentHousehold.getAttributes();
                        this.attributesReader.startTag(name, atts, context, this.currAttributes);
                    }
                } else if (name.equalsIgnoreCase("attribute")) {
                    this.attributesReader.startTag(name, atts, context, this.currAttributes);
                }
            }
        }
    }

    private Income.IncomePeriod getIncomePeriod(String s2) {
        if (Income.IncomePeriod.day.toString().equalsIgnoreCase(s2)) {
            return Income.IncomePeriod.day;
        }
        if (Income.IncomePeriod.month.toString().equalsIgnoreCase(s2)) {
            return Income.IncomePeriod.month;
        }
        if (Income.IncomePeriod.week.toString().equalsIgnoreCase(s2)) {
            return Income.IncomePeriod.week;
        }
        if (Income.IncomePeriod.hour.toString().equalsIgnoreCase(s2)) {
            return Income.IncomePeriod.hour;
        }
        if (Income.IncomePeriod.second.toString().equalsIgnoreCase(s2)) {
            return Income.IncomePeriod.second;
        }
        if (Income.IncomePeriod.year.toString().equalsIgnoreCase(s2)) {
            return Income.IncomePeriod.year;
        }
        throw new IllegalArgumentException("Not known income period!");
    }

    Households getHouseholds() {
        return this.households;
    }
}

