/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.households;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.matsim.core.utils.misc.Counter;
import org.matsim.households.Household;
import org.matsim.households.Households;
import org.matsim.households.algorithms.HouseholdAlgorithm;

public class HouseholdsAlgorithmRunner {
    private static final Logger log = Logger.getLogger(HouseholdsAlgorithmRunner.class);
    private final List<HouseholdAlgorithm> householdAlgorithms = new ArrayList<HouseholdAlgorithm>();

    public final void runAlgorithms(Households hh) {
        for (int i = 0; i < this.householdAlgorithms.size(); ++i) {
            HouseholdAlgorithm algorithm = this.householdAlgorithms.get(i);
            log.info("Running algorithm " + algorithm.getClass().getName());
            Counter c = new Counter("  household # ");
            for (Household household : hh.getHouseholds().values()) {
                algorithm.run(household);
                c.incCounter();
            }
            c.printCounter();
            log.info("Done running algorithm.");
        }
    }

    public void runAlgorithms(Household h2) {
        for (HouseholdAlgorithm algorithm : this.householdAlgorithms) {
            log.info("Running algorithm " + algorithm.getClass().getName() + " on household " + h2.getId());
            algorithm.run(h2);
        }
    }

    public final void clearAlgorithms() {
        this.householdAlgorithms.clear();
    }

    public boolean removeAlgorithm(HouseholdAlgorithm algorithm) {
        return this.householdAlgorithms.remove(algorithm);
    }

    public final void addAlgorithm(HouseholdAlgorithm algorithm) {
        this.householdAlgorithms.add(algorithm);
    }
}

