/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.households;

import java.util.LinkedHashMap;
import java.util.Map;
import org.matsim.api.core.v01.Id;
import org.matsim.households.Household;
import org.matsim.households.Households;
import org.matsim.households.HouseholdsFactory;
import org.matsim.households.HouseholdsFactoryImpl;
import org.matsim.utils.objectattributes.ObjectAttributes;

public class HouseholdsImpl
implements Households {
    private HouseholdsFactory factory;
    private Map<Id<Household>, Household> households;
    private final ObjectAttributes householdAttributes = new ObjectAttributes();

    public HouseholdsImpl() {
        this.households = new LinkedHashMap<Id<Household>, Household>();
        this.factory = new HouseholdsFactoryImpl();
    }

    public final void addHousehold(Household household) {
        if (this.getHouseholds().containsKey(household.getId())) {
            throw new IllegalArgumentException("Household with Id " + household.getId() + " already exisits.");
        }
        this.households.put(household.getId(), household);
    }

    @Override
    public HouseholdsFactory getFactory() {
        return this.factory;
    }

    public void setFactory(HouseholdsFactory factory) {
        this.factory = factory;
    }

    @Override
    public Map<Id<Household>, Household> getHouseholds() {
        return this.households;
    }

    @Override
    public ObjectAttributes getHouseholdAttributes() {
        return this.householdAttributes;
    }
}

