/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.households;

import java.util.Stack;
import org.apache.log4j.Logger;
import org.matsim.core.utils.misc.Counter;
import org.matsim.households.AbstractHouseholdsReaderV10;
import org.matsim.households.Household;
import org.matsim.households.HouseholdsAlgorithmRunner;
import org.matsim.households.HouseholdsImpl;
import org.matsim.households.HouseholdsWriterV10;

public class HouseholdsStreamingReaderV10
extends AbstractHouseholdsReaderV10 {
    private static final Logger log = Logger.getLogger(HouseholdsStreamingReaderV10.class);
    private HouseholdsWriterV10 hhWriter;
    private HouseholdsAlgorithmRunner algoRunner;
    private final Counter counter = new Counter(" household # ");

    public HouseholdsStreamingReaderV10(HouseholdsAlgorithmRunner algoRunner) {
        super(new HouseholdsImpl());
        this.algoRunner = algoRunner;
    }

    @Override
    public void endTag(String name, String content, Stack<String> context) {
        if ("household".equalsIgnoreCase(name)) {
            Household household = this.createHousehold();
            this.algoRunner.runAlgorithms(household);
            this.hhWriter.writeHousehold(household);
            this.counter.incCounter();
        }
    }

    public void readFileRunAlgorithmsAndWriteFile(String inputFile, String outputFile) {
        if (inputFile.equalsIgnoreCase(outputFile)) {
            throw new IllegalArgumentException("Inputfile and outputfile must not refer to the same filename!");
        }
        this.hhWriter = new HouseholdsWriterV10(super.getHouseholds());
        this.hhWriter.openFileAndWritePreamble(outputFile);
        super.readFile(inputFile);
        this.counter.printCounter();
        this.hhWriter.writeEndAndCloseFile();
        log.info("Done reading households, running algorithms, and writing file");
    }
}

