/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.households;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.population.Person;
import org.matsim.core.gbl.Gbl;
import org.matsim.core.utils.collections.Tuple;
import org.matsim.core.utils.io.MatsimXmlWriter;
import org.matsim.core.utils.io.UncheckedIOException;
import org.matsim.core.utils.misc.Counter;
import org.matsim.households.Household;
import org.matsim.households.Households;
import org.matsim.households.Income;
import org.matsim.households.algorithms.HouseholdAlgorithm;
import org.matsim.utils.objectattributes.AttributeConverter;
import org.matsim.utils.objectattributes.attributable.AttributesXmlWriterDelegate;
import org.matsim.vehicles.Vehicle;

public class HouseholdsWriterV10
extends MatsimXmlWriter
implements HouseholdAlgorithm {
    private static final Logger log = Logger.getLogger(HouseholdsWriterV10.class);
    private List<Tuple<String, String>> atts = new ArrayList<Tuple<String, String>>();
    private Households households;
    private final Map<Class<?>, AttributeConverter<?>> attributeConverters = new HashMap();

    public HouseholdsWriterV10(Households households) {
        this.households = households;
    }

    public <T> void putAttributeConverter(Class<T> clazz, AttributeConverter<T> converter) {
        this.attributeConverters.put(clazz, converter);
    }

    public void putAttributeConverters(Map<Class<?>, AttributeConverter<?>> converters) {
        this.attributeConverters.putAll(converters);
    }

    public void writeFile(String filename) throws UncheckedIOException {
        log.info(Gbl.aboutToWrite(" households", filename));
        this.openFileAndWritePreamble(filename);
        this.writeHouseholds(this.households);
        this.writeEndAndCloseFile();
    }

    void openFileAndWritePreamble(String filename) {
        this.openFile(filename);
        this.writeXmlHead();
        this.writeHeader();
    }

    void writeEndAndCloseFile() {
        this.writeEndTag("households");
        this.close();
    }

    private void writeHeader() {
        this.atts.clear();
        this.atts.add(HouseholdsWriterV10.createTuple("xmlns", "http://www.matsim.org/files/dtd"));
        this.atts.add(HouseholdsWriterV10.createTuple("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance"));
        this.atts.add(HouseholdsWriterV10.createTuple("xsi:schemaLocation", "http://www.matsim.org/files/dtd http://www.matsim.org/files/dtd/households_v1.0.xsd"));
        this.writeStartTag("households", this.atts);
    }

    private void writeHouseholds(Households basicHouseholds) throws UncheckedIOException {
        Counter counter = new Counter("[HouseholdsWriter] wrote household # ");
        for (Household h2 : basicHouseholds.getHouseholds().values()) {
            this.writeHousehold(h2);
            counter.incCounter();
        }
        counter.printCounter();
    }

    void writeHousehold(Household h2) throws UncheckedIOException {
        this.atts.clear();
        this.atts.add(HouseholdsWriterV10.createTuple("id", h2.getId().toString()));
        this.writeStartTag("household", this.atts);
        if (h2.getMemberIds() != null && !h2.getMemberIds().isEmpty()) {
            this.writeMembers(h2.getMemberIds());
        }
        if (h2.getVehicleIds() != null && !h2.getVehicleIds().isEmpty()) {
            this.writeStartTag("vehicles", null);
            for (Id<Vehicle> id : h2.getVehicleIds()) {
                this.atts.clear();
                this.atts.add(HouseholdsWriterV10.createTuple("refId", id.toString()));
                this.writeStartTag("vehicleDefinitionId", this.atts, true);
            }
            this.writeEndTag("vehicles");
        }
        if (h2.getIncome() != null) {
            this.writeIncome(h2.getIncome());
        }
        AttributesXmlWriterDelegate attributesWriter = new AttributesXmlWriterDelegate();
        attributesWriter.putAttributeConverters(this.attributeConverters);
        try {
            this.writer.write("\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        attributesWriter.writeAttributes("\t\t", this.writer, h2.getAttributes());
        this.writeEndTag("household");
    }

    private void writeIncome(Income income) throws UncheckedIOException {
        this.atts.clear();
        if (income.getCurrency() != null) {
            this.atts.add(HouseholdsWriterV10.createTuple("currency", income.getCurrency()));
        }
        this.atts.add(HouseholdsWriterV10.createTuple("period", income.getIncomePeriod().toString()));
        this.writeStartTag("income", this.atts);
        this.writeContent(Double.toString(income.getIncome()), true);
        this.writeEndTag("income");
    }

    private void writeMembers(List<Id<Person>> memberIds) throws UncheckedIOException {
        this.writeStartTag("members", null);
        for (Id<Person> id : memberIds) {
            this.atts.clear();
            this.atts.add(HouseholdsWriterV10.createTuple("refId", id.toString()));
            this.writeStartTag("personId", this.atts, true);
        }
        this.writeEndTag("members");
    }

    @Override
    public void run(Household household) {
        this.writeHousehold(household);
    }
}

