/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.lanes;

import java.util.ArrayList;
import java.util.List;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.network.Link;
import org.matsim.lanes.Lane;
import org.matsim.utils.objectattributes.attributable.Attributes;

final class LaneImpl
implements Lane {
    private Id<Lane> id;
    private double numberOfRepresentedLanes = 1.0;
    private double startsAtMeterFromLinkEnd = 45.0;
    private List<Id<Link>> toLinkIds;
    private List<Id<Lane>> toLaneIds;
    private int alignment = 0;
    private double capacity = 3600.0;
    private final Attributes attributes = new Attributes();

    public LaneImpl(Id<Lane> id) {
        this.id = id;
    }

    @Override
    public void setNumberOfRepresentedLanes(double number) {
        this.numberOfRepresentedLanes = number;
    }

    @Override
    public void setStartsAtMeterFromLinkEnd(double meter) {
        this.startsAtMeterFromLinkEnd = meter;
    }

    @Override
    public Id<Lane> getId() {
        return this.id;
    }

    @Override
    public double getNumberOfRepresentedLanes() {
        return this.numberOfRepresentedLanes;
    }

    @Override
    public double getStartsAtMeterFromLinkEnd() {
        return this.startsAtMeterFromLinkEnd;
    }

    @Override
    public void addToLinkId(Id<Link> id) {
        if (this.toLinkIds == null) {
            this.toLinkIds = new ArrayList<Id<Link>>();
        }
        this.toLinkIds.add(id);
    }

    @Override
    public List<Id<Link>> getToLinkIds() {
        return this.toLinkIds;
    }

    @Override
    public void addToLaneId(Id<Lane> id) {
        if (this.toLaneIds == null) {
            this.toLaneIds = new ArrayList<Id<Lane>>();
        }
        this.toLaneIds.add(id);
    }

    @Override
    public List<Id<Lane>> getToLaneIds() {
        return this.toLaneIds;
    }

    @Override
    public int getAlignment() {
        return this.alignment;
    }

    @Override
    public void setAlignment(int alignment) {
        this.alignment = alignment;
    }

    @Override
    public double getCapacityVehiclesPerHour() {
        return this.capacity;
    }

    @Override
    public void setCapacityVehiclesPerHour(double capacity) {
        this.capacity = capacity;
    }

    @Override
    public Attributes getAttributes() {
        return this.attributes;
    }
}

