/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.lanes;

import java.util.LinkedList;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Network;
import org.matsim.lanes.Lane;
import org.matsim.lanes.Lanes;
import org.matsim.lanes.LanesToLinkAssignment;
import org.matsim.utils.objectattributes.attributable.Attributable;

public final class LanesConsistencyChecker {
    private static final Logger log = Logger.getLogger(LanesConsistencyChecker.class);
    private Network network;
    private Lanes lanes;
    private boolean removeMalformed = false;

    public LanesConsistencyChecker(Network net, Lanes laneDefs) {
        this.network = net;
        this.lanes = laneDefs;
    }

    public void checkConsistency() {
        log.info("checking consistency...");
        LinkedList<Id<Link>> linksWithMalformedLanes = new LinkedList<Id<Link>>();
        for (LanesToLinkAssignment lanesToLinkAssignment : this.lanes.getLanesToLinkAssignments().values()) {
            if (this.isLaneOnLinkConsistent(lanesToLinkAssignment)) continue;
            linksWithMalformedLanes.add(lanesToLinkAssignment.getLinkId());
        }
        if (this.removeMalformed) {
            for (Id id : linksWithMalformedLanes) {
                this.lanes.getLanesToLinkAssignments().remove(id);
                log.info("remove lanes on link " + id);
            }
        }
        log.info("checked consistency. Lanes on " + linksWithMalformedLanes.size() + " links have been removed.");
    }

    private boolean isLaneOnLinkConsistent(LanesToLinkAssignment l2l) {
        if (!this.network.getLinks().containsKey(l2l.getLinkId())) {
            log.error("No link found for lanesToLinkAssignment on link Id(linkIdRef): " + l2l.getLinkId());
            return false;
        }
        Link link = this.network.getLinks().get(l2l.getLinkId());
        for (Lane l : l2l.getLanes().values()) {
            if (!(link.getLength() < l.getStartsAtMeterFromLinkEnd())) continue;
            log.error("Link Id " + link.getId() + " is shorter than an assigned lane with id " + l.getId());
            return false;
        }
        for (Lane lane : l2l.getLanes().values()) {
            if (lane.getToLaneIds() != null) {
                for (Id<Attributable> id : lane.getToLaneIds()) {
                    if (l2l.getLanes().containsKey(id)) continue;
                    log.error("Error: toLane not existing:");
                    log.error("  Lane Id: " + lane.getId() + " on Link Id: " + l2l.getLinkId() + " leads to Lane Id: " + id + " that is not existing!");
                    return false;
                }
                continue;
            }
            if (lane.getToLinkIds() == null) continue;
            for (Id<Attributable> id : lane.getToLinkIds()) {
                if (!this.network.getLinks().containsKey(id)) {
                    log.error("No link found in network for toLinkId " + id + " of laneId " + lane.getId() + " of link id " + l2l.getLinkId());
                    return false;
                }
                Link link2 = this.network.getLinks().get(l2l.getLinkId());
                if (link2.getToNode().getOutLinks().containsKey(id)) continue;
                log.error("The given toLink " + id + " is not reachable from lane " + lane.getId() + " on link " + link2.getId());
                return false;
            }
        }
        return true;
    }

    public boolean isRemoveMalformed() {
        return this.removeMalformed;
    }

    public void setRemoveMalformed(boolean removeMalformed) {
        this.removeMalformed = removeMalformed;
    }
}

