/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.lanes;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.validation.SchemaFactory;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.Scenario;
import org.matsim.api.core.v01.network.Link;
import org.matsim.core.api.internal.MatsimReader;
import org.matsim.core.utils.io.IOUtils;
import org.matsim.jaxb.lanedefinitions20.ObjectFactory;
import org.matsim.jaxb.lanedefinitions20.XMLAttributeType;
import org.matsim.jaxb.lanedefinitions20.XMLIdRefType;
import org.matsim.jaxb.lanedefinitions20.XMLLaneDefinitions;
import org.matsim.jaxb.lanedefinitions20.XMLLaneType;
import org.matsim.jaxb.lanedefinitions20.XMLLanesToLinkAssignmentType;
import org.matsim.lanes.Lane;
import org.matsim.lanes.Lanes;
import org.matsim.lanes.LanesFactory;
import org.matsim.lanes.LanesToLinkAssignment;
import org.matsim.utils.objectattributes.ObjectAttributesConverter;
import org.xml.sax.SAXException;

public final class LanesReader
implements MatsimReader {
    private static final Logger log = Logger.getLogger(LanesReader.class);
    @Deprecated
    public static final String SCHEMALOCATIONV11 = "http://www.matsim.org/files/dtd/laneDefinitions_v1.1.xsd";
    public static final String SCHEMALOCATIONV20 = "http://www.matsim.org/files/dtd/laneDefinitions_v2.0.xsd";
    private Lanes lanes;
    private LanesFactory factory;
    private final ObjectAttributesConverter attributesConverter = new ObjectAttributesConverter();

    public LanesReader(Scenario scenario) {
        this.lanes = scenario.getLanes();
        this.factory = this.lanes.getFactory();
    }

    @Override
    public void readFile(String filename) {
        try {
            log.info("reading file " + filename);
            InputStream inputStream = IOUtils.getInputStream(filename);
            this.parse(inputStream);
        }
        catch (JAXBException | SAXException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void readURL(URL url) {
        try {
            log.info("reading file " + url.toString());
            InputStream inputStream = IOUtils.getInputStream(url);
            this.parse(inputStream);
        }
        catch (JAXBException | SAXException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse(InputStream stream) throws JAXBException, SAXException {
        XMLLaneDefinitions xmlLaneDefinitions;
        ObjectFactory fac = new ObjectFactory();
        JAXBContext jc = JAXBContext.newInstance(ObjectFactory.class);
        Unmarshaller u = jc.createUnmarshaller();
        u.setSchema(SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(this.getClass().getResource("/dtd/laneDefinitions_v2.0.xsd")));
        try {
            xmlLaneDefinitions = (XMLLaneDefinitions)u.unmarshal(stream);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e) {
                log.warn("Could not close stream.", e);
            }
        }
        for (XMLLanesToLinkAssignmentType lldef : xmlLaneDefinitions.getLanesToLinkAssignment()) {
            LanesToLinkAssignment l2lAssignment = this.factory.createLanesToLinkAssignment(Id.create(lldef.getLinkIdRef(), Link.class));
            for (XMLLaneType laneType : lldef.getLane()) {
                Lane lane = this.factory.createLane(Id.create(laneType.getId(), Lane.class));
                if (!laneType.getLeadsTo().getToLane().isEmpty()) {
                    for (XMLIdRefType toLaneId : laneType.getLeadsTo().getToLane()) {
                        lane.addToLaneId(Id.create(toLaneId.getRefId(), Lane.class));
                    }
                } else if (!laneType.getLeadsTo().getToLink().isEmpty()) {
                    for (XMLIdRefType toLinkId : laneType.getLeadsTo().getToLink()) {
                        lane.addToLinkId(Id.create(toLinkId.getRefId(), Link.class));
                    }
                }
                if (laneType.getCapacity() == null) {
                    log.warn("Capacity not set in lane definition, using default...");
                    laneType.setCapacity(fac.createXMLLaneTypeXMLCapacity());
                }
                lane.setCapacityVehiclesPerHour(laneType.getCapacity().getVehiclesPerHour());
                if (laneType.getRepresentedLanes() == null) {
                    laneType.setRepresentedLanes(fac.createXMLLaneTypeXMLRepresentedLanes());
                }
                lane.setNumberOfRepresentedLanes(laneType.getRepresentedLanes().getNumber());
                if (laneType.getStartsAt() == null) {
                    laneType.setStartsAt(fac.createXMLLaneTypeXMLStartsAt());
                }
                lane.setStartsAtMeterFromLinkEnd(laneType.getStartsAt().getMeterFromLinkEnd());
                lane.setAlignment(laneType.getAlignment());
                if (laneType.getAttributes() != null && !laneType.getAttributes().getAttributeList().isEmpty()) {
                    for (XMLAttributeType att : laneType.getAttributes().getAttributeList()) {
                        Object attribute = this.attributesConverter.convert(att.getClazz(), att.getValue());
                        if (attribute == null) continue;
                        lane.getAttributes().putAttribute(att.getKey(), attribute);
                    }
                }
                l2lAssignment.addLane(lane);
            }
            this.lanes.addLanesToLinkAssignment(l2lAssignment);
        }
    }
}

