/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.lanes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.Scenario;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Network;
import org.matsim.core.config.Config;
import org.matsim.core.config.ConfigUtils;
import org.matsim.core.scenario.ScenarioUtils;
import org.matsim.lanes.Lane;
import org.matsim.lanes.Lanes;
import org.matsim.lanes.LanesFactory;
import org.matsim.lanes.LanesImpl;
import org.matsim.lanes.LanesToLinkAssignment;
import org.matsim.lanes.LanesWriter;
import org.matsim.lanes.ModelLane;
import org.matsim.utils.objectattributes.attributable.Attributable;

public final class LanesUtils {
    public static Lanes createLanesContainer() {
        return new LanesImpl();
    }

    public static void createAndAddLane(LanesToLinkAssignment l2l, LanesFactory factory, Id<Lane> laneId, double capacity, double startsAtMeterFromLinkEnd, int alignment, int numberOfRepresentedLanes, List<Id<Link>> toLinkIds, List<Id<Lane>> toLaneIds) {
        Lane lane = factory.createLane(laneId);
        if (toLinkIds != null) {
            for (Id<Attributable> id : toLinkIds) {
                lane.addToLinkId(id);
            }
        }
        if (toLaneIds != null) {
            for (Id<Attributable> id : toLaneIds) {
                lane.addToLaneId(id);
            }
        }
        lane.setCapacityVehiclesPerHour(capacity);
        lane.setStartsAtMeterFromLinkEnd(startsAtMeterFromLinkEnd);
        lane.setNumberOfRepresentedLanes(numberOfRepresentedLanes);
        lane.setAlignment(alignment);
        l2l.addLane(lane);
    }

    public static void createOriginalLanesAndSetLaneCapacities(Network network, Lanes lanes) {
        LanesFactory factory = lanes.getFactory();
        for (LanesToLinkAssignment l2l : lanes.getLanesToLinkAssignments().values()) {
            Link link = network.getLinks().get(l2l.getLinkId());
            Lane olLane = factory.createLane(Id.create(l2l.getLinkId().toString() + ".ol", Lane.class));
            l2l.addLane(olLane);
            for (Lane lane : l2l.getLanes().values()) {
                olLane.addToLaneId(lane.getId());
                LanesUtils.calculateAndSetCapacity(lane, true, link, network);
            }
            olLane.setNumberOfRepresentedLanes(link.getNumberOfLanes());
            olLane.setStartsAtMeterFromLinkEnd(link.getLength());
        }
    }

    public static List<ModelLane> createLanes(Link link, LanesToLinkAssignment lanesToLinkAssignment) {
        ArrayList<ModelLane> queueLanes = new ArrayList<ModelLane>();
        ArrayList<Lane> sortedLanes = new ArrayList<Lane>(lanesToLinkAssignment.getLanes().values());
        Collections.sort(sortedLanes, new Comparator<Lane>(){

            @Override
            public int compare(Lane o1, Lane o2) {
                if (o1.getStartsAtMeterFromLinkEnd() < o2.getStartsAtMeterFromLinkEnd()) {
                    return -1;
                }
                if (o1.getStartsAtMeterFromLinkEnd() > o2.getStartsAtMeterFromLinkEnd()) {
                    return 1;
                }
                return 0;
            }
        });
        Collections.reverse(sortedLanes);
        LinkedList<ModelLane> laneList = new LinkedList<ModelLane>();
        Lane firstLane = (Lane)sortedLanes.remove(0);
        if (firstLane.getStartsAtMeterFromLinkEnd() != link.getLength()) {
            throw new IllegalStateException("First Lane Id " + firstLane.getId() + " on Link Id " + link.getId() + "isn't starting at the beginning of the link!");
        }
        ModelLane firstQLane = new ModelLane(firstLane);
        laneList.add(firstQLane);
        Stack<ModelLane> laneStack = new Stack<ModelLane>();
        while (!laneList.isEmpty()) {
            ModelLane lastQLane = (ModelLane)laneList.remove(0);
            laneStack.push(lastQLane);
            queueLanes.add(lastQLane);
            List<Id<Lane>> toLaneIds = lastQLane.getLaneData().getToLaneIds();
            double d = 0.0;
            double laneLength = 0.0;
            if (toLaneIds != null && !toLaneIds.isEmpty()) {
                for (Id<Lane> toLaneId : toLaneIds) {
                    Lane currentLane = (Lane)lanesToLinkAssignment.getLanes().get(toLaneId);
                    d = currentLane.getStartsAtMeterFromLinkEnd();
                    ModelLane currentQLane = new ModelLane(currentLane);
                    laneList.add(currentQLane);
                    lastQLane.addAToLane(currentQLane);
                }
                laneLength = lastQLane.getLaneData().getStartsAtMeterFromLinkEnd() - d;
                lastQLane.setEndsAtMetersFromLinkEnd(d);
            } else {
                laneLength = lastQLane.getLaneData().getStartsAtMeterFromLinkEnd();
                lastQLane.setEndsAtMetersFromLinkEnd(0.0);
            }
            lastQLane.setLength(laneLength);
        }
        while (!laneStack.isEmpty()) {
            ModelLane qLane = (ModelLane)laneStack.pop();
            if (qLane.getToLanes() == null || qLane.getToLanes().isEmpty()) {
                for (Id id : qLane.getLaneData().getToLinkIds()) {
                    qLane.addDestinationLink(id);
                }
                continue;
            }
            for (ModelLane modelLane : qLane.getToLanes()) {
                for (Id<Link> toLinkId : modelLane.getDestinationLinkIds()) {
                    qLane.addDestinationLink(toLinkId);
                }
            }
        }
        Collections.sort(queueLanes, new Comparator<ModelLane>(){

            @Override
            public int compare(ModelLane o1, ModelLane o2) {
                if (o1.getEndsAtMeterFromLinkEnd() < o2.getEndsAtMeterFromLinkEnd()) {
                    return -1;
                }
                if (o1.getEndsAtMeterFromLinkEnd() > o2.getEndsAtMeterFromLinkEnd()) {
                    return 1;
                }
                return 0;
            }
        });
        return queueLanes;
    }

    public static void calculateAndSetCapacity(Lane lane, boolean isLaneAtLinkEnd, Link link, Network network) {
        if (isLaneAtLinkEnd) {
            double noLanesLink = link.getNumberOfLanes();
            double linkFlowCapPerSecondPerLane = link.getCapacity() / network.getCapacityPeriod() / noLanesLink;
            double laneFlowCapPerHour = lane.getNumberOfRepresentedLanes() * linkFlowCapPerSecondPerLane * 3600.0;
            lane.setCapacityVehiclesPerHour(laneFlowCapPerHour);
        } else {
            double capacity = link.getCapacity() / network.getCapacityPeriod() * 3600.0;
            lane.setCapacityVehiclesPerHour(capacity);
        }
    }

    public static void calculateMissingCapacitiesForLanes20(String networkInputFilename, String lanes20InputFilename, String lanes20OutputFilename) {
        Config config = ConfigUtils.createConfig();
        config.network().setInputFile(networkInputFilename);
        config.qsim().setUseLanes(true);
        config.network().setLaneDefinitionsFile(lanes20InputFilename);
        Scenario scenario = ScenarioUtils.loadScenario(config);
        Network network = scenario.getNetwork();
        Lanes lanes = scenario.getLanes();
        for (LanesToLinkAssignment l2l : lanes.getLanesToLinkAssignments().values()) {
            Link link = network.getLinks().get(l2l.getLinkId());
            for (Lane lane : l2l.getLanes().values()) {
                if (lane.getToLaneIds() == null || lane.getToLaneIds().isEmpty()) {
                    LanesUtils.calculateAndSetCapacity(lane, true, link, network);
                    continue;
                }
                LanesUtils.calculateAndSetCapacity(lane, false, link, network);
            }
        }
        LanesWriter writerDelegate = new LanesWriter(lanes);
        writerDelegate.write(lanes20OutputFilename);
    }

    public static void overwriteLaneCapacitiesByNetworkCapacities(Network net, Lanes lanes) {
        for (LanesToLinkAssignment linkLanes : lanes.getLanesToLinkAssignments().values()) {
            double linkCap = net.getLinks().get(linkLanes.getLinkId()).getCapacity();
            for (Lane lane : linkLanes.getLanes().values()) {
                lane.setCapacityVehiclesPerHour(linkCap);
            }
        }
    }
}

