/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.lanes;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.crypto.MarshalException;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Id;
import org.matsim.core.api.internal.MatsimSomeWriter;
import org.matsim.core.gbl.Gbl;
import org.matsim.core.utils.io.IOUtils;
import org.matsim.core.utils.io.MatsimJaxbXmlWriter;
import org.matsim.jaxb.lanedefinitions20.ObjectFactory;
import org.matsim.jaxb.lanedefinitions20.XMLAttributeType;
import org.matsim.jaxb.lanedefinitions20.XMLIdRefType;
import org.matsim.jaxb.lanedefinitions20.XMLLaneDefinitions;
import org.matsim.jaxb.lanedefinitions20.XMLLaneType;
import org.matsim.jaxb.lanedefinitions20.XMLLanesToLinkAssignmentType;
import org.matsim.lanes.Lane;
import org.matsim.lanes.Lanes;
import org.matsim.lanes.LanesToLinkAssignment;
import org.matsim.utils.objectattributes.ObjectAttributesConverter;
import org.matsim.utils.objectattributes.attributable.Attributable;

public final class LanesWriter
extends MatsimJaxbXmlWriter
implements MatsimSomeWriter {
    private static final Logger log = Logger.getLogger(LanesWriter.class);
    private Lanes laneDefinitions;
    private final ObjectAttributesConverter attributesConverter = new ObjectAttributesConverter();

    public LanesWriter(Lanes lanedefs) {
        this.laneDefinitions = lanedefs;
    }

    @Override
    public void write(String filename) {
        log.info(Gbl.aboutToWrite("lanes", filename));
        try {
            XMLLaneDefinitions xmlLaneDefinitions = this.convertDataToXml();
            JAXBContext jc = JAXBContext.newInstance(ObjectFactory.class);
            Marshaller m3 = jc.createMarshaller();
            MatsimJaxbXmlWriter.setMarshallerProperties("http://www.matsim.org/files/dtd/laneDefinitions_v2.0.xsd", m3);
            BufferedWriter bufout = IOUtils.getBufferedWriter(filename);
            m3.marshal((Object)xmlLaneDefinitions, bufout);
            bufout.close();
        }
        catch (IOException | JAXBException | MarshalException e) {
            throw new RuntimeException(e);
        }
    }

    private XMLLaneDefinitions convertDataToXml() throws MarshalException {
        ObjectFactory fac = new ObjectFactory();
        XMLLaneDefinitions xmllaneDefs = fac.createXMLLaneDefinitions();
        for (LanesToLinkAssignment ltla : this.laneDefinitions.getLanesToLinkAssignments().values()) {
            XMLLanesToLinkAssignmentType xmlltla = fac.createXMLLanesToLinkAssignmentType();
            xmlltla.setLinkIdRef(ltla.getLinkId().toString());
            for (Lane bl : ltla.getLanes().values()) {
                XMLIdRefType xmlToLink;
                XMLLaneType xmllane = fac.createXMLLaneType();
                xmllane.setId(bl.getId().toString());
                if (!(bl.getToLinkIds() == null && bl.getToLaneIds() != null || bl.getToLinkIds() != null && bl.getToLaneIds() == null)) {
                    throw new MarshalException("Either at least one toLinkId or (exclusive) one toLaneId mustbe set for Lane Id " + bl.getId() + " on link Id " + ltla.getLinkId() + "! Cannot write according to XML grammar.");
                }
                xmllane.setLeadsTo(fac.createXMLLaneTypeXMLLeadsTo());
                if (bl.getToLinkIds() != null) {
                    for (Id<Attributable> id : bl.getToLinkIds()) {
                        xmlToLink = fac.createXMLIdRefType();
                        xmlToLink.setRefId(id.toString());
                        xmllane.getLeadsTo().getToLink().add(xmlToLink);
                    }
                } else if (bl.getToLaneIds() != null) {
                    for (Id<Attributable> id : bl.getToLaneIds()) {
                        xmlToLink = fac.createXMLIdRefType();
                        xmlToLink.setRefId(id.toString());
                        xmllane.getLeadsTo().getToLane().add(xmlToLink);
                    }
                }
                XMLLaneType.XMLCapacity capacity = new XMLLaneType.XMLCapacity();
                capacity.setVehiclesPerHour(bl.getCapacityVehiclesPerHour());
                xmllane.setCapacity(capacity);
                XMLLaneType.XMLRepresentedLanes xMLRepresentedLanes = new XMLLaneType.XMLRepresentedLanes();
                xMLRepresentedLanes.setNumber(bl.getNumberOfRepresentedLanes());
                xmllane.setRepresentedLanes(xMLRepresentedLanes);
                XMLLaneType.XMLStartsAt startsAt = new XMLLaneType.XMLStartsAt();
                startsAt.setMeterFromLinkEnd(bl.getStartsAtMeterFromLinkEnd());
                xmllane.setStartsAt(startsAt);
                xmllane.setAlignment(bl.getAlignment());
                if (bl.getAttributes() != null) {
                    xmllane.setAttributes(fac.createXMLLaneTypeXMLAttributes());
                    for (Map.Entry<String, Object> objAttribute : bl.getAttributes().getAsMap().entrySet()) {
                        Class<?> clazz = objAttribute.getValue().getClass();
                        String converted = this.attributesConverter.convertToString(objAttribute.getValue());
                        if (converted == null) continue;
                        XMLAttributeType att = fac.createXMLAttributeType();
                        att.setKey(objAttribute.getKey());
                        att.setValue(converted);
                        att.setClazz(clazz.getCanonicalName());
                        xmllane.getAttributes().getAttributeList().add(att);
                    }
                }
                xmlltla.getLane().add(xmllane);
            }
            xmllaneDefs.getLanesToLinkAssignment().add(xmlltla);
        }
        return xmllaneDefs;
    }
}

