/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.lanes;

import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.matsim.api.core.v01.Coord;
import org.matsim.core.mobsim.qsim.interfaces.SignalGroupState;
import org.matsim.core.utils.collections.Tuple;
import org.matsim.core.utils.geometry.CoordUtils;
import org.matsim.lanes.VisLinkWLanes;
import org.matsim.lanes.VisSignal;

public final class VisLane
implements Serializable {
    private String id = null;
    private double endPosition;
    private double startPosition;
    private int alignment;
    private double numberOfLanes;
    private List<VisLane> toLanes = null;
    private SignalGroupState state = null;
    private Point2D.Double startPoint = null;
    private Point2D.Double endPoint = null;
    private Map<String, VisSignal> signals = null;
    private List<String> toLinkIds;
    private transient List<VisLinkWLanes> toLinksData = null;
    private double euklideanDistance;
    private Coord startCoord;
    private Coord endCoord;
    private Map<Integer, Tuple<Coord, Coord>> drivingLaneMap = null;

    public VisLane(String id) {
        this.id = id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void setEndPosition(double pos) {
        this.endPosition = pos;
    }

    public double getEndPosition() {
        return this.endPosition;
    }

    public double getStartPosition() {
        return this.startPosition;
    }

    public void setStartPosition(double pos) {
        this.startPosition = pos;
    }

    public void setAlignment(int alignment) {
        this.alignment = alignment;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public double getNumberOfLanes() {
        return this.numberOfLanes;
    }

    public void setNumberOfLanes(double noLanes) {
        this.numberOfLanes = noLanes;
    }

    public void setSignalGroupState(SignalGroupState state) {
        this.state = state;
    }

    public SignalGroupState getSignalGroupState() {
        return this.state;
    }

    public void addToLink(VisLinkWLanes toLink) {
        if (this.toLinksData == null) {
            this.toLinksData = new ArrayList<VisLinkWLanes>();
        }
        this.toLinksData.add(toLink);
    }

    public void addToLane(VisLane toLane) {
        if (this.toLanes == null) {
            this.toLanes = new ArrayList<VisLane>();
        }
        this.toLanes.add(toLane);
    }

    public Point2D.Double getStartPoint() {
        return this.startPoint;
    }

    public void setStartEndPoint(Point2D.Double startPoint, Point2D.Double endPoint) {
        this.startPoint = startPoint;
        this.endPoint = endPoint;
        this.calcCoords();
    }

    public Point2D.Double getEndPoint() {
        return this.endPoint;
    }

    private void calcCoords() {
        this.startCoord = new Coord(this.startPoint.x, this.startPoint.y);
        this.endCoord = new Coord(this.endPoint.x, this.endPoint.y);
        this.euklideanDistance = CoordUtils.calcEuclideanDistance(this.startCoord, this.endCoord);
    }

    public void addDrivingLane(int laneNumber, Point2D.Double drivingLaneStart, Point2D.Double drivingLaneEnd) {
        if (this.drivingLaneMap == null) {
            this.drivingLaneMap = new HashMap<Integer, Tuple<Coord, Coord>>();
        }
        Tuple<Coord, Coord> tuple = new Tuple<Coord, Coord>(new Coord(drivingLaneStart.x, drivingLaneStart.y), new Coord(drivingLaneEnd.x, drivingLaneEnd.y));
        this.drivingLaneMap.put(laneNumber, tuple);
    }

    public Tuple<Coord, Coord> getDrivingLaneStartEndCoord(int laneNumber) {
        return this.drivingLaneMap.get(laneNumber);
    }

    public Coord getStartCoord() {
        return this.startCoord;
    }

    public Coord getEndCoord() {
        return this.endCoord;
    }

    public void addSignal(VisSignal signal) {
        if (this.signals == null) {
            this.signals = new HashMap<String, VisSignal>();
        }
        this.signals.put(signal.getId(), signal);
    }

    public Map<String, VisSignal> getSignals() {
        return this.signals;
    }

    public List<VisLinkWLanes> getToLinks() {
        return this.toLinksData;
    }

    public void addToLinkId(String toLinkId) {
        if (this.toLinkIds == null) {
            this.toLinkIds = new ArrayList<String>();
        }
        this.toLinkIds.add(toLinkId);
    }

    public List<String> getToLinkIds() {
        return this.toLinkIds;
    }

    public List<VisLane> getToLanes() {
        return this.toLanes;
    }

    public double getEuklideanDistance() {
        return this.euklideanDistance;
    }
}

