/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.lanes;

import java.awt.geom.Point2D;
import java.util.List;
import java.util.Map;
import org.matsim.api.core.v01.Coord;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.network.Link;
import org.matsim.core.utils.collections.Tuple;
import org.matsim.core.utils.geometry.CoordinateTransformation;
import org.matsim.lanes.ModelLane;
import org.matsim.lanes.VisLane;
import org.matsim.lanes.VisLinkWLanes;
import org.matsim.vis.snapshotwriters.SnapshotLinkWidthCalculator;
import org.matsim.vis.snapshotwriters.VisLink;
import org.matsim.vis.vecmathutils.VectorUtils;

public final class VisLaneModelBuilder {
    public void recalculatePositions(VisLinkWLanes linkData, SnapshotLinkWidthCalculator linkWidthCalculator) {
        double linkWidth = linkWidthCalculator.calculateLinkWidth(linkData.getNumberOfLanes());
        linkData.setLinkWidth(linkWidth);
        Point2D.Double linkStartCenter = this.calculatePointOnLink(linkData, 0.0, 0.5);
        linkData.setLinkStartCenterPoint(linkStartCenter);
        if (linkData.getLaneData() == null || linkData.getLaneData().isEmpty()) {
            double x = linkData.getLinkEnd().x + 0.5 * linkWidth * linkData.getLinkOrthogonalVector().x;
            double y = linkData.getLinkEnd().y + 0.5 * linkWidth * linkData.getLinkOrthogonalVector().y;
            linkData.setLinkEndCenterPoint(new Point2D.Double(x, y));
        } else {
            double numberOfLinkParts = 2 * linkData.getMaximalAlignment() + 2;
            for (VisLane lane : linkData.getLaneData().values()) {
                double horizontalFraction = 0.5 - (double)lane.getAlignment() / numberOfLinkParts;
                Point2D.Double laneStart = this.calculatePointOnLink(linkData, lane.getStartPosition(), horizontalFraction);
                Point2D.Double laneEnd = this.calculatePointOnLink(linkData, lane.getEndPosition(), horizontalFraction);
                lane.setStartEndPoint(laneStart, laneEnd);
                if (!(lane.getNumberOfLanes() >= 2.0)) continue;
                double noLanesFloor = Math.floor(lane.getNumberOfLanes());
                double laneOffset = -noLanesFloor / 2.0 * linkWidthCalculator.getLaneWidth();
                if (noLanesFloor % 2.0 == 0.0) {
                    laneOffset += linkWidthCalculator.getLaneWidth() / 2.0;
                }
                int i = 1;
                while ((double)i <= noLanesFloor) {
                    Point2D.Double drivingLaneStart = this.calcPoint(laneStart, linkData.getLinkOrthogonalVector(), laneOffset);
                    Point2D.Double drivingLaneEnd = this.calcPoint(laneEnd, linkData.getLinkOrthogonalVector(), laneOffset);
                    lane.addDrivingLane(i, drivingLaneStart, drivingLaneEnd);
                    laneOffset += linkWidthCalculator.getLaneWidth();
                    ++i;
                }
            }
        }
    }

    private Point2D.Double calculatePointOnLink(VisLinkWLanes laneLinkData, double position, double horizontalFraction) {
        Point2D.Double lenghtPoint = this.calcPoint(laneLinkData.getLinkStart(), laneLinkData.getNormalizedLinkVector(), position);
        return this.calcPoint(lenghtPoint, laneLinkData.getLinkOrthogonalVector(), horizontalFraction * laneLinkData.getLinkWidth());
    }

    public Point2D.Double calcPoint(Point2D.Double start, Point2D.Double vector, double distance) {
        double x = start.getX() + distance * vector.x;
        double y = start.getY() + distance * vector.y;
        return new Point2D.Double(x, y);
    }

    private VisLane createVisLane(ModelLane qlane, double linkLength, double linkScale, double linkLengthCorrectionFactor) {
        String id = qlane.getLaneData().getId().toString();
        double startPosition = (linkLength - qlane.getLaneData().getStartsAtMeterFromLinkEnd()) * linkScale * linkLengthCorrectionFactor;
        double endPosition = startPosition + qlane.getLength() * linkScale * linkLengthCorrectionFactor;
        int alignment = qlane.getLaneData().getAlignment();
        VisLane lane = new VisLane(id);
        lane.setStartPosition(startPosition);
        lane.setEndPosition(endPosition);
        lane.setAlignment(alignment);
        lane.setNumberOfLanes(qlane.getLaneData().getNumberOfRepresentedLanes());
        return lane;
    }

    public void connect(Map<String, VisLinkWLanes> otfNetwork) {
        for (VisLinkWLanes otfLink : otfNetwork.values()) {
            if (otfLink.getLaneData() == null || otfLink.getLaneData().isEmpty()) {
                if (otfLink.getToLinkIds() == null) continue;
                for (String toLinkId : otfLink.getToLinkIds()) {
                    VisLinkWLanes toLink = otfNetwork.get(toLinkId);
                    otfLink.addToLink(toLink);
                }
                continue;
            }
            for (VisLane otfLane : otfLink.getLaneData().values()) {
                if (otfLane.getToLinkIds() == null) continue;
                for (String toLinkId : otfLane.getToLinkIds()) {
                    VisLinkWLanes toLink = otfNetwork.get(toLinkId);
                    otfLane.addToLink(toLink);
                }
            }
        }
    }

    public VisLinkWLanes createVisLinkLanes(CoordinateTransformation transform, VisLink link, double nodeOffsetMeter, List<ModelLane> lanes) {
        Coord linkStartCoord = transform.transform(link.getLink().getFromNode().getCoord());
        Coord linkEndCoord = transform.transform(link.getLink().getToNode().getCoord());
        Point2D.Double linkStart = new Point2D.Double(linkStartCoord.getX(), linkStartCoord.getY());
        Point2D.Double linkEnd = new Point2D.Double(linkEndCoord.getX(), linkEndCoord.getY());
        Point2D.Double deltaLink = new Point2D.Double(linkEnd.x - linkStart.x, linkEnd.y - linkStart.y);
        double euclideanLinkLength = this.calculateEuclideanLinkLength(deltaLink);
        double linkLengthCorrectionFactor = euclideanLinkLength / link.getLink().getLength();
        Point2D.Double deltaLinkNorm = new Point2D.Double(deltaLink.x / euclideanLinkLength, deltaLink.y / euclideanLinkLength);
        Point2D.Double normalizedOrthogonal = new Point2D.Double(deltaLinkNorm.y, -deltaLinkNorm.x);
        double linkScale = 1.0;
        linkScale = euclideanLinkLength * 0.2 > 2.0 * nodeOffsetMeter ? (euclideanLinkLength - 2.0 * nodeOffsetMeter) / euclideanLinkLength : euclideanLinkLength * 0.8 / euclideanLinkLength;
        Tuple<Point2D.Double, Point2D.Double> scaledLink = VectorUtils.scaleVector(linkStart, linkEnd, linkScale);
        Point2D.Double scaledLinkEnd = scaledLink.getSecond();
        Point2D.Double scaledLinkStart = scaledLink.getFirst();
        VisLinkWLanes lanesLinkData = new VisLinkWLanes(link.getLink().getId().toString());
        lanesLinkData.setLinkStartEndPoint(scaledLinkStart, scaledLinkEnd);
        lanesLinkData.setNormalizedLinkVector(deltaLinkNorm);
        lanesLinkData.setLinkOrthogonalVector(normalizedOrthogonal);
        lanesLinkData.setNumberOfLanes(link.getLink().getNumberOfLanes());
        if (lanes != null) {
            int maxAlignment = 0;
            for (ModelLane lane : lanes) {
                VisLane visLane = this.createVisLane(lane, link.getLink().getLength(), linkScale, linkLengthCorrectionFactor);
                lanesLinkData.addLaneData(visLane);
                if (visLane.getAlignment() <= maxAlignment) continue;
                maxAlignment = visLane.getAlignment();
            }
            lanesLinkData.setMaximalAlignment(maxAlignment);
            for (ModelLane lane : lanes) {
                VisLane otfLane = lanesLinkData.getLaneData().get(lane.getLaneData().getId().toString());
                if (lane.getToLanes() == null || lane.getToLanes().isEmpty()) {
                    for (Id id : lane.getLaneData().getToLinkIds()) {
                        otfLane.addToLinkId(id.toString());
                    }
                    continue;
                }
                for (ModelLane modelLane : lane.getToLanes()) {
                    VisLane otfToLane = lanesLinkData.getLaneData().get(modelLane.getLaneData().getId().toString());
                    otfLane.addToLane(otfToLane);
                }
            }
        } else {
            for (Id<Link> id : link.getLink().getToNode().getOutLinks().keySet()) {
                lanesLinkData.addToLinkId(id.toString());
            }
        }
        return lanesLinkData;
    }

    private double calculateEuclideanLinkLength(Point2D.Double deltaLink) {
        return Math.sqrt(Math.pow(deltaLink.x, 2.0) + Math.pow(deltaLink.y, 2.0));
    }
}

