/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.lanes;

import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.matsim.api.core.v01.Coord;
import org.matsim.core.utils.geometry.CoordUtils;
import org.matsim.lanes.VisLane;
import org.matsim.lanes.VisSignal;

public final class VisLinkWLanes
implements Serializable {
    private Point2D.Double linkStart = null;
    private Point2D.Double linkEnd = null;
    private Point2D.Double normalizedLinkVector;
    private Point2D.Double linkOrthogonalVector;
    private double numberOfLanes = 1.0;
    private int maximalAlignment = 0;
    private Map<String, VisLane> laneData = null;
    private String id = null;
    private double linkWidth;
    private Point2D.Double linkStartCenterPoint = null;
    private Point2D.Double linkEndCenterPoint = null;
    private Map<String, VisSignal> signals = null;
    private ArrayList<String> toLinkIds;
    private transient List<VisLinkWLanes> toLinks = null;
    private Coord startCoord;
    private Coord endCoord;
    private double euklideanDistance;

    public VisLinkWLanes(String id) {
        this.id = id;
    }

    public String getLinkId() {
        return this.id;
    }

    public void setNormalizedLinkVector(Point2D.Double v) {
        this.normalizedLinkVector = v;
    }

    public void setLinkOrthogonalVector(Point2D.Double v) {
        this.linkOrthogonalVector = v;
    }

    public Point2D.Double getLinkStart() {
        return this.linkStart;
    }

    public Point2D.Double getLinkEnd() {
        return this.linkEnd;
    }

    public Point2D.Double getNormalizedLinkVector() {
        return this.normalizedLinkVector;
    }

    public Point2D.Double getLinkOrthogonalVector() {
        return this.linkOrthogonalVector;
    }

    public void setNumberOfLanes(double nrLanes) {
        this.numberOfLanes = nrLanes;
    }

    public double getNumberOfLanes() {
        return this.numberOfLanes;
    }

    public void setMaximalAlignment(int maxAlign) {
        this.maximalAlignment = maxAlign;
    }

    public int getMaximalAlignment() {
        return this.maximalAlignment;
    }

    public void addLaneData(VisLane laneData) {
        if (this.laneData == null) {
            this.laneData = new HashMap<String, VisLane>();
        }
        this.laneData.put(laneData.getId(), laneData);
    }

    public Map<String, VisLane> getLaneData() {
        return this.laneData;
    }

    public void addSignal(VisSignal signal) {
        if (this.signals == null) {
            this.signals = new HashMap<String, VisSignal>();
        }
        this.signals.put(signal.getId(), signal);
    }

    public Map<String, VisSignal> getSignals() {
        return this.signals;
    }

    public void setLinkWidth(double linkWidth) {
        this.linkWidth = linkWidth;
    }

    public double getLinkWidth() {
        return this.linkWidth;
    }

    public void setLinkStartEndPoint(Point2D.Double linkStart, Point2D.Double linkEnd) {
        this.linkStart = linkStart;
        this.linkEnd = linkEnd;
        this.calcCoords();
    }

    public void setLinkStartCenterPoint(Point2D.Double linkStartCenter) {
        this.linkStartCenterPoint = linkStartCenter;
    }

    public void setLinkEndCenterPoint(Point2D.Double linkEndCenter) {
        this.linkEndCenterPoint = linkEndCenter;
    }

    public Coord getLinkStartCoord() {
        return this.startCoord;
    }

    public Coord getLinkEndCoord() {
        return this.endCoord;
    }

    private void calcCoords() {
        this.startCoord = new Coord(this.linkStart.x, this.linkStart.y);
        this.endCoord = new Coord(this.linkEnd.x, this.linkEnd.y);
        this.euklideanDistance = CoordUtils.calcEuclideanDistance(this.startCoord, this.endCoord);
    }

    public double getEuklideanDistance() {
        return this.euklideanDistance;
    }

    public Point2D.Double getLinkStartCenterPoint() {
        return this.linkStartCenterPoint;
    }

    public Point2D.Double getLinkEndCenterPoint() {
        return this.linkEndCenterPoint;
    }

    public void addToLink(VisLinkWLanes link) {
        if (this.toLinks == null) {
            this.toLinks = new ArrayList<VisLinkWLanes>();
        }
        this.toLinks.add(link);
    }

    public List<VisLinkWLanes> getToLinks() {
        return this.toLinks;
    }

    public void addToLinkId(String toLinkId) {
        if (this.toLinkIds == null) {
            this.toLinkIds = new ArrayList();
        }
        this.toLinkIds.add(toLinkId);
    }

    public List<String> getToLinkIds() {
        return this.toLinkIds;
    }
}

