/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.matrices;

import java.util.TreeMap;
import org.matsim.matrices.Matrix;

public class Matrices {
    private String name = null;
    private final TreeMap<String, Matrix> matrices = new TreeMap();

    public final Matrix createMatrix(String id, String desc) {
        if (this.matrices.containsKey(id)) {
            throw new RuntimeException("[id=" + id + " already exists.]");
        }
        Matrix m3 = new Matrix(id, desc);
        this.matrices.put(id, m3);
        return m3;
    }

    protected final void setName(String name) {
        this.name = name;
    }

    public final String getName() {
        return this.name;
    }

    public final TreeMap<String, Matrix> getMatrices() {
        return this.matrices;
    }

    public final Matrix getMatrix(String id) {
        return this.matrices.get(id);
    }

    public final String toString() {
        return "[name=" + this.name + "]" + "[nof_matrices=" + this.matrices.size() + "]";
    }
}

