/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.matrices;

import java.util.Stack;
import org.matsim.core.utils.io.MatsimXmlParser;
import org.matsim.matrices.Matrices;
import org.matsim.matrices.Matrix;
import org.xml.sax.Attributes;

public class MatricesReaderMatsimV1<T>
extends MatsimXmlParser {
    private static final String MATRICES = "matrices";
    private static final String MATRIX = "matrix";
    private static final String ENTRY = "entry";
    private Matrices matrices;
    private Matrix currMatrix = null;

    public MatricesReaderMatsimV1(Matrices matrices) {
        this.matrices = matrices;
    }

    @Override
    public void startTag(String name, Attributes atts, Stack<String> context) {
        if (MATRICES.equals(name)) {
            this.startMatrices(atts);
        } else if (MATRIX.equals(name)) {
            this.startMatrix(atts);
        } else if (ENTRY.equals(name)) {
            this.startEntry(atts);
        } else {
            throw new RuntimeException(this + "[tag=" + name + " not known or not supported]");
        }
    }

    @Override
    public void endTag(String name, String content, Stack<String> context) {
        if (MATRICES.equals(name)) {
            this.matrices = null;
        } else if (MATRIX.equals(name)) {
            this.currMatrix = null;
        }
    }

    private void startMatrices(Attributes atts) {
        this.matrices.setName(atts.getValue("name"));
    }

    private void startMatrix(Attributes atts) {
        this.currMatrix = this.matrices.createMatrix(atts.getValue("id"), atts.getValue("desc"));
    }

    private void startEntry(Attributes atts) {
        this.currMatrix.createAndAddEntry(atts.getValue("from_id"), atts.getValue("to_id"), Double.parseDouble(atts.getValue("value")));
    }
}

