/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.matrices;

import java.io.IOException;
import java.util.ArrayList;
import org.matsim.core.api.internal.MatsimWriter;
import org.matsim.core.utils.io.MatsimXmlWriter;
import org.matsim.matrices.Entry;
import org.matsim.matrices.Matrices;
import org.matsim.matrices.MatricesWriterHandler;
import org.matsim.matrices.MatricesWriterHandlerImplV1;
import org.matsim.matrices.Matrix;

public class MatricesWriter
extends MatsimXmlWriter
implements MatsimWriter {
    private MatricesWriterHandler handler = null;
    private final Matrices matrices;
    private String dtd;

    public MatricesWriter(Matrices matrices) {
        this.matrices = matrices;
        this.dtd = "http://matsim.org/files/dtd/matrices_v1.dtd";
        this.handler = new MatricesWriterHandlerImplV1();
    }

    @Override
    public final void write(String filename) {
        try {
            this.openFile(filename);
            this.writeXmlHead();
            this.writeDoctype("matrices", this.dtd);
            this.handler.startMatrices(this.matrices, this.writer);
            this.handler.writeSeparator(this.writer);
            for (Matrix m3 : this.matrices.getMatrices().values()) {
                this.handler.startMatrix(m3, this.writer);
                for (ArrayList<Entry> eal : m3.getFromLocations().values()) {
                    for (Entry e : eal) {
                        this.handler.startEntry(e, this.writer);
                        this.handler.endEntry(this.writer);
                    }
                }
                this.handler.endMatrix(this.writer);
                this.handler.writeSeparator(this.writer);
                this.writer.flush();
            }
            this.handler.endMatrices(this.writer);
            this.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public final String toString() {
        return super.toString();
    }
}

