/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.matrices;

import java.io.BufferedWriter;
import java.io.IOException;
import org.matsim.matrices.Entry;
import org.matsim.matrices.Matrices;
import org.matsim.matrices.MatricesWriterHandler;
import org.matsim.matrices.Matrix;

class MatricesWriterHandlerImplV1
implements MatricesWriterHandler {
    MatricesWriterHandlerImplV1() {
    }

    @Override
    public void startMatrices(Matrices matrices, BufferedWriter out) throws IOException {
        out.write("<matrices");
        if (matrices.getName() != null) {
            out.write(" name=\"" + matrices.getName() + "\"");
        }
        out.write(">\n\n");
    }

    @Override
    public void endMatrices(BufferedWriter out) throws IOException {
        out.write("</matrices>\n");
    }

    @Override
    public void startMatrix(Matrix matrix, BufferedWriter out) throws IOException {
        out.write("\t<matrix");
        out.write(" id=\"" + matrix.getId() + "\"");
        if (matrix.getDesc() != null) {
            out.write(" desc=\"" + matrix.getDesc() + "\"");
        }
        out.write(">\n");
    }

    @Override
    public void endMatrix(BufferedWriter out) throws IOException {
        out.write("\t</matrix>\n\n");
    }

    @Override
    public void startEntry(Entry entry, BufferedWriter out) throws IOException {
        out.write("\t\t<entry");
        out.write(" from_id=\"" + entry.getFromLocation() + "\"");
        out.write(" to_id=\"" + entry.getToLocation() + "\"");
        out.write(" value=\"" + entry.getValue() + "\"");
        out.write(" />\n");
    }

    @Override
    public void endEntry(BufferedWriter out) throws IOException {
    }

    @Override
    public void writeSeparator(BufferedWriter out) throws IOException {
        out.write("<!-- ====================================================================== -->\n\n");
    }
}

