/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.matrices;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.matsim.matrices.Entry;

public final class Matrix {
    private final String id;
    private String desc = null;
    private final TreeMap<String, ArrayList<Entry>> fromLocs = new TreeMap();
    private final TreeMap<String, ArrayList<Entry>> toLocs = new TreeMap();
    private static final Logger log = Logger.getLogger(Matrix.class);
    private long counter = 0L;
    private long nextMsg = 1L;

    public Matrix(String id, String desc) {
        if (id == null) {
            throw new NullPointerException("id must not be null");
        }
        this.id = id;
        this.desc = desc;
    }

    public final Entry createAndAddEntry(String fromLocId, String toLocId, double value) {
        Entry e = new Entry(fromLocId, toLocId, value);
        if (!this.fromLocs.containsKey(fromLocId)) {
            this.fromLocs.put(fromLocId, new ArrayList());
        }
        ArrayList<Entry> fe = this.fromLocs.get(fromLocId);
        fe.add(e);
        if (!this.toLocs.containsKey(toLocId)) {
            this.toLocs.put(toLocId, new ArrayList());
        }
        ArrayList<Entry> te = this.toLocs.get(toLocId);
        te.add(e);
        ++this.counter;
        if (this.counter % this.nextMsg == 0L) {
            this.nextMsg *= 2L;
            log.info("Matrix id=" + this.id + ": entry # " + this.counter);
        }
        return e;
    }

    public final Entry setEntry(String fromLocId, String toLocId, double value) {
        Entry e = this.getEntry(fromLocId, toLocId);
        if (e == null) {
            return this.createAndAddEntry(fromLocId, toLocId, value);
        }
        e.setValue(value);
        return e;
    }

    public final void setDesc(String desc) {
        this.desc = desc;
    }

    public final void removeEntry(String from_loc, String to_loc) {
        Entry entry = this.getEntry(from_loc, to_loc);
        ArrayList<Entry> from_loc_entries = this.fromLocs.get(from_loc);
        ArrayList<Entry> to_loc_entries = this.toLocs.get(to_loc);
        if (from_loc_entries == null || to_loc_entries == null) {
            throw new RuntimeException("entry with from_loc_id=" + from_loc + " and to_loc_id=" + to_loc + " does not exist!" + " Inconsistent data strucutre!!!");
        }
        if (!from_loc_entries.remove(entry)) {
            throw new RuntimeException("entry with from_loc_id=" + from_loc + " and to_loc_id=" + to_loc + " does not exist!" + " Inconsistent data strucutre!!!");
        }
        if (from_loc_entries.isEmpty()) {
            this.fromLocs.remove(from_loc);
        }
        if (!to_loc_entries.remove(entry)) {
            throw new RuntimeException("entry with from_loc_id=" + from_loc + " and to_loc_id=" + to_loc + " does not exist!" + " Inconsistent data strucutre!!!");
        }
        if (to_loc_entries.isEmpty()) {
            this.toLocs.remove(to_loc);
        }
        log.info("entry " + entry.toString() + " removed.");
    }

    public final String getId() {
        return this.id;
    }

    public final String getDesc() {
        return this.desc;
    }

    public final Map<String, ArrayList<Entry>> getFromLocations() {
        return this.fromLocs;
    }

    public final Map<String, ArrayList<Entry>> getToLocations() {
        return this.toLocs;
    }

    public final List<Entry> getFromLocEntries(String fromLocationId) {
        return this.fromLocs.get(fromLocationId);
    }

    public final List<Entry> getToLocEntries(String toLocationId) {
        return this.toLocs.get(toLocationId);
    }

    public final Entry getEntry(String from, String to) {
        ArrayList<Entry> fe = this.fromLocs.get(from);
        if (fe == null) {
            return null;
        }
        for (int i = 0; i < fe.size(); ++i) {
            Entry e = fe.get(i);
            if (!e.getToLocation().equals(to)) continue;
            return e;
        }
        return null;
    }

    public final String toString() {
        return "[id=" + this.id + "]" + "[desc=" + this.desc + "]" + "[nof_from_locs=" + this.fromLocs.size() + "]" + "[nof_to_locs=" + this.toLocs.size() + "]";
    }
}

