/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.matrices;

import java.util.Stack;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Scenario;
import org.matsim.core.utils.io.MatsimXmlParser;
import org.matsim.matrices.Matrices;
import org.matsim.matrices.MatricesReaderMatsimV1;
import org.xml.sax.Attributes;

public class MatsimMatricesReader
extends MatsimXmlParser {
    private static final Logger log = Logger.getLogger(MatsimMatricesReader.class);
    private static final String MATRICES_V1 = "matrices_v1.dtd";
    private final Matrices matrices;
    private MatsimXmlParser delegate = null;
    private final Scenario scenario;

    public MatsimMatricesReader(Matrices matrices, Scenario scenario) {
        this.matrices = matrices;
        this.scenario = scenario;
    }

    @Override
    public void startTag(String name, Attributes atts, Stack<String> context) {
        this.delegate.startTag(name, atts, context);
    }

    @Override
    public void endTag(String name, String content, Stack<String> context) {
        this.delegate.endTag(name, content, context);
    }

    @Override
    protected void setDoctype(String doctype) {
        super.setDoctype(doctype);
        if (!MATRICES_V1.equals(doctype)) {
            throw new IllegalArgumentException("Doctype \"" + doctype + "\" not known.");
        }
        this.delegate = new MatricesReaderMatsimV1(this.matrices);
        log.info("using matrices_v1-reader.");
    }
}

