/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.pt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.matsim.api.core.v01.Id;
import org.matsim.pt.Umlauf;
import org.matsim.pt.UmlaufStueckI;
import org.matsim.pt.transitSchedule.api.TransitLine;
import org.matsim.vehicles.Vehicle;

public class UmlaufImpl
implements Umlauf {
    private Id<Umlauf> id;
    private Id<Vehicle> vehicleId;
    private ArrayList<UmlaufStueckI> umlaufStuecke = new ArrayList();

    public UmlaufImpl(Id<Umlauf> id) {
        this.id = id;
    }

    @Override
    public List<UmlaufStueckI> getUmlaufStuecke() {
        return this.umlaufStuecke;
    }

    @Override
    public Id<Umlauf> getId() {
        return this.id;
    }

    @Override
    public void setVehicleId(Id<Vehicle> vehicleId) {
        this.vehicleId = vehicleId;
        for (UmlaufStueckI umlaufStueck : this.umlaufStuecke) {
            if (!umlaufStueck.isFahrt()) continue;
            umlaufStueck.getDeparture().setVehicleId(vehicleId);
        }
    }

    @Override
    public Id<Vehicle> getVehicleId() {
        return this.vehicleId;
    }

    @Override
    public Id<TransitLine> getLineId() {
        return this.getLineId(this.getUmlaufStuecke());
    }

    private Id<TransitLine> getLineId(Collection<UmlaufStueckI> umlaufInConstruction) {
        Id lineId = null;
        for (UmlaufStueckI umlaufStueck : umlaufInConstruction) {
            if (!umlaufStueck.isFahrt() || lineId != null) continue;
            lineId = umlaufStueck.getLine().getId();
        }
        return lineId;
    }
}

