/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.pt;

import java.util.List;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Network;
import org.matsim.api.core.v01.network.Node;
import org.matsim.core.config.groups.PlanCalcScoreConfigGroup;
import org.matsim.core.network.NetworkUtils;
import org.matsim.core.population.routes.NetworkRoute;
import org.matsim.core.population.routes.RouteUtils;
import org.matsim.core.router.DijkstraFactory;
import org.matsim.core.router.costcalculators.FreespeedTravelTimeAndDisutility;
import org.matsim.core.router.util.LeastCostPathCalculator;
import org.matsim.pt.Umlauf;
import org.matsim.pt.UmlaufStueck;
import org.matsim.pt.UmlaufStueckI;
import org.matsim.pt.Wenden;

public class UmlaufInterpolator {
    private final Network network;
    private final LeastCostPathCalculator routingAlgo;

    public UmlaufInterpolator(Network network, PlanCalcScoreConfigGroup config) {
        this.network = network;
        FreespeedTravelTimeAndDisutility travelTimes = new FreespeedTravelTimeAndDisutility(config);
        this.routingAlgo = new DijkstraFactory().createPathCalculator(network, travelTimes, travelTimes);
    }

    public void addUmlaufStueckToUmlauf(UmlaufStueck umlaufStueck, Umlauf umlauf) {
        Id<Link> toLinkId;
        UmlaufStueckI previousUmlaufStueck;
        NetworkRoute previousCarRoute;
        Id<Link> fromLinkId;
        List<UmlaufStueckI> umlaufStueckeOfThisUmlauf = umlauf.getUmlaufStuecke();
        if (!umlaufStueckeOfThisUmlauf.isEmpty() && !(fromLinkId = (previousCarRoute = (previousUmlaufStueck = umlaufStueckeOfThisUmlauf.get(umlaufStueckeOfThisUmlauf.size() - 1)).getCarRoute()).getEndLinkId()).equals(toLinkId = umlaufStueck.getCarRoute().getStartLinkId())) {
            this.insertWenden(fromLinkId, toLinkId, umlauf);
        }
        umlaufStueckeOfThisUmlauf.add(umlaufStueck);
    }

    private void insertWenden(Id<Link> fromLinkId, Id<Link> toLinkId, Umlauf umlauf) {
        double depTime;
        Node endNode;
        Node startNode = this.network.getLinks().get(fromLinkId).getToNode();
        LeastCostPathCalculator.Path wendenPath = this.routingAlgo.calcLeastCostPath(startNode, endNode = this.network.getLinks().get(toLinkId).getFromNode(), depTime = 0.0, null, null);
        if (wendenPath == null) {
            throw new RuntimeException("No route found from node " + startNode.getId() + " to node " + endNode.getId() + ".");
        }
        NetworkRoute route = RouteUtils.createLinkNetworkRouteImpl(fromLinkId, toLinkId);
        route.setLinkIds(fromLinkId, NetworkUtils.getLinkIds(wendenPath.links), toLinkId);
        umlauf.getUmlaufStuecke().add(new Wenden(route));
    }
}

