/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.pt.analysis;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.events.PersonEntersVehicleEvent;
import org.matsim.api.core.v01.events.PersonLeavesVehicleEvent;
import org.matsim.api.core.v01.events.handler.PersonEntersVehicleEventHandler;
import org.matsim.api.core.v01.events.handler.PersonLeavesVehicleEventHandler;
import org.matsim.pt.analysis.VehicleTracker;
import org.matsim.pt.transitSchedule.api.Departure;
import org.matsim.pt.transitSchedule.api.TransitRoute;

public class RouteOccupancy
implements PersonEntersVehicleEventHandler,
PersonLeavesVehicleEventHandler {
    private static final Integer Int1 = 1;
    private final TransitRoute transitRoute;
    private final VehicleTracker tracker;
    private Set<Id> routeVehicles = null;
    private final Map<Id, Integer> enteringPassengers = new HashMap<Id, Integer>();
    private final Map<Id, Integer> leavingPassengers = new HashMap<Id, Integer>();

    public RouteOccupancy(TransitRoute transitRoute, VehicleTracker tracker) {
        this.transitRoute = transitRoute;
        this.tracker = tracker;
    }

    @Override
    public void handleEvent(PersonEntersVehicleEvent event) {
        if (this.routeVehicles == null) {
            this.collectVehiclesInfo();
        }
        if (this.routeVehicles.contains(event.getVehicleId())) {
            Id facilityId = this.tracker.getFacilityIdForVehicle(event.getVehicleId());
            Integer count = this.enteringPassengers.get(facilityId);
            if (count == null) {
                this.enteringPassengers.put(facilityId, Int1);
            } else {
                this.enteringPassengers.put(facilityId, 1 + count);
            }
        }
    }

    @Override
    public void handleEvent(PersonLeavesVehicleEvent event) {
        if (this.routeVehicles == null) {
            this.collectVehiclesInfo();
        }
        if (this.routeVehicles.contains(event.getVehicleId())) {
            Id facilityId = this.tracker.getFacilityIdForVehicle(event.getVehicleId());
            Integer count = this.leavingPassengers.get(facilityId);
            if (count == null) {
                this.leavingPassengers.put(facilityId, Int1);
            } else {
                this.leavingPassengers.put(facilityId, 1 + count);
            }
        }
    }

    @Override
    public void reset(int iteration) {
        this.routeVehicles = null;
        this.enteringPassengers.clear();
        this.leavingPassengers.clear();
    }

    public int getNumberOfEnteringPassengers(Id stopFacilityId) {
        Integer count = this.enteringPassengers.get(stopFacilityId);
        if (count == null) {
            return 0;
        }
        return count;
    }

    public int getNumberOfLeavingPassengers(Id stopFacilityId) {
        Integer count = this.leavingPassengers.get(stopFacilityId);
        if (count == null) {
            return 0;
        }
        return count;
    }

    private void collectVehiclesInfo() {
        HashSet<Id> set = new HashSet<Id>(this.transitRoute.getDepartures().size() * 2);
        for (Departure departure : this.transitRoute.getDepartures().values()) {
            if (departure.getVehicleId() == null) continue;
            set.add(departure.getVehicleId());
        }
        this.routeVehicles = set;
    }
}

