/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.pt.analysis;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtils;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.matsim.api.core.v01.Id;
import org.matsim.core.api.experimental.events.VehicleArrivesAtFacilityEvent;
import org.matsim.core.api.experimental.events.VehicleDepartsAtFacilityEvent;
import org.matsim.core.api.experimental.events.handler.VehicleArrivesAtFacilityEventHandler;
import org.matsim.core.api.experimental.events.handler.VehicleDepartsAtFacilityEventHandler;
import org.matsim.core.utils.collections.Tuple;
import org.matsim.pt.transitSchedule.api.Departure;
import org.matsim.pt.transitSchedule.api.TransitRoute;
import org.matsim.pt.transitSchedule.api.TransitRouteStop;
import org.matsim.pt.transitSchedule.api.TransitStopFacility;
import org.matsim.vehicles.Vehicle;

public class RouteTimeDiagram
implements VehicleArrivesAtFacilityEventHandler,
VehicleDepartsAtFacilityEventHandler {
    private final Map<Id, List<Tuple<Id, Double>>> positions = new HashMap<Id, List<Tuple<Id, Double>>>();

    @Override
    public void handleEvent(VehicleArrivesAtFacilityEvent event) {
        List<Tuple<Id, Double>> list = this.positions.get(event.getVehicleId());
        if (list == null) {
            list = new ArrayList<Tuple<Id, Double>>();
            this.positions.put(event.getVehicleId(), list);
        }
        list.add(new Tuple<Id<TransitStopFacility>, Double>(event.getFacilityId(), event.getTime()));
    }

    @Override
    public void handleEvent(VehicleDepartsAtFacilityEvent event) {
        List<Tuple<Id, Double>> list = this.positions.get(event.getVehicleId());
        if (list == null) {
            list = new ArrayList<Tuple<Id, Double>>();
            this.positions.put(event.getVehicleId(), list);
        }
        list.add(new Tuple<Id<TransitStopFacility>, Double>(event.getFacilityId(), event.getTime()));
    }

    @Override
    public void reset(int iteration) {
        this.positions.clear();
    }

    public void writeData() {
        for (List<Tuple<Id, Double>> list : this.positions.values()) {
            for (Tuple<Id, Double> info : list) {
                System.out.println(info.getFirst().toString() + "\t" + info.getSecond().toString());
            }
            System.out.println();
        }
    }

    public void createGraph(String filename, TransitRoute route) {
        HashMap stopIndex = new HashMap();
        int idx = 0;
        for (TransitRouteStop transitRouteStop : route.getStops()) {
            stopIndex.put(transitRouteStop.getStopFacility().getId(), idx);
            ++idx;
        }
        HashSet<Id<Vehicle>> vehicles = new HashSet<Id<Vehicle>>();
        for (Departure dep : route.getDepartures().values()) {
            vehicles.add(dep.getVehicleId());
        }
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
        int numSeries = 0;
        double earliestTime = Double.POSITIVE_INFINITY;
        double latestTime = Double.NEGATIVE_INFINITY;
        for (Map.Entry<Id, List<Tuple<Id, Double>>> entry : this.positions.entrySet()) {
            if (!vehicles.contains(entry.getKey())) continue;
            XYSeries series = new XYSeries((Comparable)((Object)"t"), false, true);
            for (Tuple<Id, Double> pos : entry.getValue()) {
                Integer stopIdx = (Integer)stopIndex.get(pos.getFirst());
                if (stopIdx == null) continue;
                double time = pos.getSecond();
                series.add((double)stopIdx.intValue(), time);
                if (time < earliestTime) {
                    earliestTime = time;
                }
                if (!(time > latestTime)) continue;
                latestTime = time;
            }
            xYSeriesCollection.addSeries(series);
            ++numSeries;
        }
        JFreeChart c = ChartFactory.createXYLineChart("Route-Time Diagram, Route = " + route.getId(), "stops", "time", xYSeriesCollection, PlotOrientation.VERTICAL, false, false, false);
        c.setBackgroundPaint(new Color(1.0f, 1.0f, 1.0f, 1.0f));
        XYPlot p = (XYPlot)c.getPlot();
        p.getRangeAxis().setInverted(true);
        p.getRangeAxis().setRange(earliestTime, latestTime);
        XYItemRenderer renderer = p.getRenderer();
        for (int i = 0; i < numSeries; ++i) {
            renderer.setSeriesPaint(i, Color.black);
        }
        try {
            ChartUtils.saveChartAsPNG(new File(filename), c, 1024, 768, null, true, 9);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

