/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.pt.analysis;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.events.PersonEntersVehicleEvent;
import org.matsim.api.core.v01.events.PersonLeavesVehicleEvent;
import org.matsim.api.core.v01.events.TransitDriverStartsEvent;
import org.matsim.api.core.v01.events.handler.PersonEntersVehicleEventHandler;
import org.matsim.api.core.v01.events.handler.PersonLeavesVehicleEventHandler;
import org.matsim.api.core.v01.events.handler.TransitDriverStartsEventHandler;
import org.matsim.api.core.v01.population.Person;
import org.matsim.core.api.experimental.events.VehicleArrivesAtFacilityEvent;
import org.matsim.core.api.experimental.events.VehicleDepartsAtFacilityEvent;
import org.matsim.core.api.experimental.events.handler.VehicleArrivesAtFacilityEventHandler;
import org.matsim.core.api.experimental.events.handler.VehicleDepartsAtFacilityEventHandler;
import org.matsim.core.utils.misc.Time;
import org.matsim.pt.transitSchedule.api.Departure;
import org.matsim.pt.transitSchedule.api.TransitLine;
import org.matsim.pt.transitSchedule.api.TransitRoute;
import org.matsim.pt.transitSchedule.api.TransitRouteStop;
import org.matsim.pt.transitSchedule.api.TransitStopFacility;
import org.matsim.vehicles.Vehicle;

public class TransitLoad
implements TransitDriverStartsEventHandler,
VehicleArrivesAtFacilityEventHandler,
VehicleDepartsAtFacilityEventHandler,
PersonEntersVehicleEventHandler,
PersonLeavesVehicleEventHandler {
    private final Map<Id<TransitLine>, LineData> lineData = new HashMap<Id<TransitLine>, LineData>();
    private final Map<Id<Vehicle>, Id<TransitStopFacility>> vehicleFacilityMap = new HashMap<Id<Vehicle>, Id<TransitStopFacility>>();
    private final Map<Id<Vehicle>, VehicleData> vehicleData = new HashMap<Id<Vehicle>, VehicleData>();

    @Deprecated
    public int getLoadAtDeparture(TransitLine line, TransitRoute route, TransitStopFacility stopFacility, Departure departure) {
        for (int i = 0; i < route.getStops().size(); ++i) {
            if (!route.getStops().get(i).getStopFacility().getId().equals(stopFacility.getId())) continue;
            return this.getLoadAtDeparture(line, route, i, departure);
        }
        return -1;
    }

    public int getLoadAtDeparture(TransitLine line, TransitRoute route, int transitRouteStopIndex, Departure departure) {
        int nOfPassengers = 0;
        HashMap stop2nrVisited = new HashMap();
        for (int i = 0; i < route.getStops().size(); ++i) {
            StopInformation si;
            TransitRouteStop stop = route.getStops().get(i);
            Integer nrVisited = (Integer)stop2nrVisited.get(stop.getStopFacility().getId());
            if (nrVisited == null) {
                nrVisited = 0;
            } else {
                Integer n = nrVisited;
                Integer n2 = nrVisited = Integer.valueOf(nrVisited + 1);
            }
            stop2nrVisited.put(stop.getStopFacility().getId(), nrVisited);
            List<StopInformation> siList = this.getStopInformation(line.getId(), route.getId(), stop.getStopFacility().getId(), departure.getId(), false);
            if (siList != null && (si = siList.get(nrVisited)) != null) {
                nOfPassengers -= si.nOfLeaving;
                nOfPassengers += si.nOfEntering;
            }
            if (i != transitRouteStopIndex) continue;
            return nOfPassengers;
        }
        return -1;
    }

    public List<StopInformation> getDepartureStopInformation(TransitLine line, TransitRoute route, TransitStopFacility stopFacility, Departure departure) {
        return this.getStopInformation(line.getId(), route.getId(), stopFacility.getId(), departure.getId(), false);
    }

    @Override
    public void handleEvent(TransitDriverStartsEvent event) {
        this.vehicleData.put(event.getVehicleId(), new VehicleData(event.getVehicleId(), event.getTransitLineId(), event.getTransitRouteId(), event.getDepartureId(), event.getDriverId()));
    }

    @Override
    public void handleEvent(VehicleArrivesAtFacilityEvent event) {
        this.vehicleFacilityMap.put(event.getVehicleId(), event.getFacilityId());
        VehicleData vData = this.vehicleData.get(event.getVehicleId());
        if (vData != null) {
            List<StopInformation> siList = this.getStopInformation(vData.lineId, vData.routeId, this.vehicleFacilityMap.get(event.getVehicleId()), vData.departureId, true);
            StopInformation si = new StopInformation();
            si.arrivalTime = event.getTime();
            siList.add(si);
        }
    }

    @Override
    public void handleEvent(VehicleDepartsAtFacilityEvent event) {
        Id<TransitStopFacility> stopId = this.vehicleFacilityMap.remove(event.getVehicleId());
        VehicleData vData = this.vehicleData.get(event.getVehicleId());
        if (vData != null) {
            List<StopInformation> siList = this.getStopInformation(vData.lineId, vData.routeId, stopId, vData.departureId, true);
            StopInformation si = siList.get(siList.size() - 1);
            si.departureTime = event.getTime();
        }
    }

    @Override
    public void handleEvent(PersonEntersVehicleEvent event) {
        VehicleData vData = this.vehicleData.get(event.getVehicleId());
        if (vData != null && !vData.driverId.equals(event.getPersonId())) {
            List<StopInformation> siList = this.getStopInformation(vData.lineId, vData.routeId, this.vehicleFacilityMap.get(event.getVehicleId()), vData.departureId, true);
            StopInformation si = siList.get(siList.size() - 1);
            si.nOfEntering = (short)(si.nOfEntering + 1);
        }
    }

    @Override
    public void handleEvent(PersonLeavesVehicleEvent event) {
        VehicleData vData = this.vehicleData.get(event.getVehicleId());
        if (vData != null && !vData.driverId.equals(event.getPersonId())) {
            List<StopInformation> siList = this.getStopInformation(vData.lineId, vData.routeId, this.vehicleFacilityMap.get(event.getVehicleId()), vData.departureId, true);
            StopInformation si = siList.get(siList.size() - 1);
            si.nOfLeaving = (short)(si.nOfLeaving + 1);
        }
    }

    @Override
    public void reset(int iteration) {
        this.vehicleFacilityMap.clear();
        this.vehicleData.clear();
    }

    private List<StopInformation> getStopInformation(Id<TransitLine> lineId, Id<TransitRoute> routeId, Id<TransitStopFacility> stopFacilityId, Id<Departure> departureId, boolean createIfMissing) {
        List<StopInformation> siList;
        StopData sd;
        RouteData rd;
        LineData ld = this.lineData.get(lineId);
        if (ld == null) {
            if (createIfMissing) {
                ld = new LineData();
                this.lineData.put(lineId, ld);
            } else {
                return null;
            }
        }
        if ((rd = ld.routeData.get(routeId)) == null) {
            if (createIfMissing) {
                rd = new RouteData();
                ld.routeData.put(routeId, rd);
            } else {
                return null;
            }
        }
        if ((sd = rd.stopData.get(stopFacilityId)) == null) {
            if (createIfMissing) {
                sd = new StopData();
                rd.stopData.put(stopFacilityId, sd);
            } else {
                return null;
            }
        }
        if ((siList = sd.departureData.get(departureId)) == null) {
            if (createIfMissing) {
                siList = new ArrayList<StopInformation>();
                sd.departureData.put(departureId, siList);
            } else {
                return null;
            }
        }
        return siList;
    }

    public static class StopInformation {
        public short nOfEntering = 0;
        public short nOfLeaving = 0;
        public double arrivalTime = Time.getUndefinedTime();
        public double departureTime = Time.getUndefinedTime();
    }

    static class StopData {
        public final Map<Id<Departure>, List<StopInformation>> departureData = new HashMap<Id<Departure>, List<StopInformation>>();

        StopData() {
        }
    }

    static class RouteData {
        public final Map<Id<TransitStopFacility>, StopData> stopData = new HashMap<Id<TransitStopFacility>, StopData>();

        RouteData() {
        }
    }

    static class LineData {
        public final Map<Id<TransitRoute>, RouteData> routeData = new HashMap<Id<TransitRoute>, RouteData>();

        LineData() {
        }
    }

    private static class VehicleData {
        public final Id<Vehicle> vehicleId;
        public final Id<TransitLine> lineId;
        public final Id<TransitRoute> routeId;
        public final Id<Departure> departureId;
        public final Id<Person> driverId;

        public VehicleData(Id<Vehicle> vehicleId, Id<TransitLine> lineId, Id<TransitRoute> routeId, Id<Departure> departureId, Id<Person> driverId) {
            this.vehicleId = vehicleId;
            this.lineId = lineId;
            this.routeId = routeId;
            this.departureId = departureId;
            this.driverId = driverId;
        }
    }
}

