/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.pt.analysis;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.events.PersonEntersVehicleEvent;
import org.matsim.api.core.v01.events.PersonLeavesVehicleEvent;
import org.matsim.api.core.v01.events.handler.PersonEntersVehicleEventHandler;
import org.matsim.api.core.v01.events.handler.PersonLeavesVehicleEventHandler;
import org.matsim.core.utils.misc.Time;
import org.matsim.pt.analysis.VehicleTracker;
import org.matsim.pt.transitSchedule.api.Departure;
import org.matsim.pt.transitSchedule.api.TransitRoute;
import org.matsim.pt.transitSchedule.api.TransitRouteStop;

public class TransitRouteAccessEgressAnalysis
implements PersonEntersVehicleEventHandler,
PersonLeavesVehicleEventHandler {
    public final TransitRoute transitRoute;
    public Map<Id, Departure> headings = null;
    private final Map<Departure, Map<Id, Integer>> accessCounters = new LinkedHashMap<Departure, Map<Id, Integer>>();
    private final Map<Departure, Map<Id, Integer>> egressCounters = new LinkedHashMap<Departure, Map<Id, Integer>>();
    private final VehicleTracker vehTracker;

    public TransitRouteAccessEgressAnalysis(TransitRoute transitRoute, VehicleTracker vehicleTracker) {
        this.transitRoute = transitRoute;
        this.vehTracker = vehicleTracker;
    }

    @Override
    public void handleEvent(PersonEntersVehicleEvent event) {
        Departure dep;
        if (this.headings == null) {
            this.collectHeadingsInfo();
        }
        if ((dep = this.headings.get(event.getVehicleId())) != null) {
            Id fId = this.vehTracker.getFacilityIdForVehicle(event.getVehicleId());
            Map<Id, Integer> counter = this.getAccessCounter(dep);
            Integer count = counter.get(fId);
            if (count == null) {
                counter.put(fId, 1);
            } else {
                counter.put(fId, 1 + count);
            }
        }
    }

    @Override
    public void handleEvent(PersonLeavesVehicleEvent event) {
        Departure dep;
        if (this.headings == null) {
            this.collectHeadingsInfo();
        }
        if ((dep = this.headings.get(event.getVehicleId())) != null) {
            Id fId = this.vehTracker.getFacilityIdForVehicle(event.getVehicleId());
            Map<Id, Integer> counter = this.getEgressCounter(dep);
            Integer count = counter.get(fId);
            if (count == null) {
                counter.put(fId, 1);
            } else {
                counter.put(fId, 1 + count);
            }
        }
    }

    @Override
    public void reset(int iteration) {
        this.headings = null;
        this.accessCounters.clear();
        this.egressCounters.clear();
    }

    public void printStats() {
        ArrayList stopFacilityIds = new ArrayList(this.transitRoute.getStops().size());
        for (TransitRouteStop transitRouteStop : this.transitRoute.getStops()) {
            stopFacilityIds.add(transitRouteStop.getStopFacility().getId());
        }
        System.out.print("stops/departure");
        for (Id id : stopFacilityIds) {
            System.out.print("\t" + id);
        }
        System.out.println();
        for (Departure departure : this.headings.values()) {
            System.out.print(Time.writeTime(departure.getDepartureTime()));
            Map<Id, Integer> accessCounter = this.getAccessCounter(departure);
            for (Id id : stopFacilityIds) {
                Integer n = accessCounter.get(id);
                System.out.print("\t");
                if (n != null) {
                    System.out.print(n.toString());
                    continue;
                }
                System.out.print("0");
            }
            System.out.println();
            Map<Id, Integer> egressCounter = this.getEgressCounter(departure);
            for (Id id : stopFacilityIds) {
                Integer value = egressCounter.get(id);
                System.out.print("\t");
                if (value != null) {
                    System.out.print(value.toString());
                    continue;
                }
                System.out.print("0");
            }
            System.out.println();
        }
    }

    public Map<Id, Integer> getAccessCounter(Departure departure) {
        Map<Id, Integer> counter = this.accessCounters.get(departure);
        if (counter == null) {
            counter = new HashMap<Id, Integer>();
            this.accessCounters.put(departure, counter);
        }
        return counter;
    }

    public Map<Id, Integer> getEgressCounter(Departure departure) {
        Map<Id, Integer> counter = this.egressCounters.get(departure);
        if (counter == null) {
            counter = new HashMap<Id, Integer>();
            this.egressCounters.put(departure, counter);
        }
        return counter;
    }

    private void collectHeadingsInfo() {
        HashMap<Id, Departure> map = new HashMap<Id, Departure>(this.transitRoute.getDepartures().size() * 2);
        for (Departure departure : this.transitRoute.getDepartures().values()) {
            if (departure.getVehicleId() == null) continue;
            map.put(departure.getVehicleId(), departure);
        }
        this.headings = map;
    }
}

