/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.pt.analysis;

import java.util.HashMap;
import java.util.Map;
import org.matsim.api.core.v01.Id;
import org.matsim.core.api.experimental.events.VehicleArrivesAtFacilityEvent;
import org.matsim.core.api.experimental.events.VehicleDepartsAtFacilityEvent;
import org.matsim.core.api.experimental.events.handler.VehicleArrivesAtFacilityEventHandler;
import org.matsim.core.api.experimental.events.handler.VehicleDepartsAtFacilityEventHandler;

public class VehicleTracker
implements VehicleArrivesAtFacilityEventHandler,
VehicleDepartsAtFacilityEventHandler {
    private final Map<Id, Id> vehicleFacilityMap = new HashMap<Id, Id>();

    @Override
    public void handleEvent(VehicleArrivesAtFacilityEvent event) {
        this.vehicleFacilityMap.put(event.getVehicleId(), event.getFacilityId());
    }

    @Override
    public void handleEvent(VehicleDepartsAtFacilityEvent event) {
        this.vehicleFacilityMap.remove(event.getVehicleId());
    }

    @Override
    public void reset(int iteration) {
        this.vehicleFacilityMap.clear();
    }

    public Id getFacilityIdForVehicle(Id vehicleId) {
        return this.vehicleFacilityMap.get(vehicleId);
    }
}

