/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.pt.config;

import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.matsim.core.config.ConfigGroup;
import org.matsim.core.config.ReflectiveConfigGroup;
import org.matsim.core.utils.collections.CollectionUtils;

public class TransitConfigGroup
extends ReflectiveConfigGroup {
    public static final String GROUP_NAME = "transit";
    static final String TRANSIT_SCHEDULE_FILE = "transitScheduleFile";
    private static final String TRANSIT_LINES_ATTRIBUTES = "transitLinesAttributesFile";
    private static final String TRANSIT_STOPS_ATTRIBUTES = "transitStopsAttributesFile";
    static final String VEHICLES_FILE = "vehiclesFile";
    static final String TRANSIT_MODES = "transitModes";
    private static final String SCHEDULE_CRS = "inputScheduleCRS";
    private String transitScheduleFile = null;
    private String vehiclesFile = null;
    private String transitLinesAttributesFile = null;
    private String transitStopsAttributesFile = null;
    private String inputScheduleCRS = null;
    private Set<String> transitModes;
    private static final String USE_TRANSIT = "useTransit";
    private boolean useTransit = false;
    public static final String BOARDING_ACCEPTANCE_CMT = "under which conditions agent boards transit vehicle";
    private BoardingAcceptance boardingAcceptance = BoardingAcceptance.checkLineAndStop;
    private boolean usingTransitInMobsim = true;

    public TransitConfigGroup() {
        super(GROUP_NAME);
        LinkedHashSet<String> modes = new LinkedHashSet<String>();
        modes.add("pt");
        this.transitModes = Collections.unmodifiableSet(modes);
    }

    @ReflectiveConfigGroup.StringSetter(value="transitModes")
    private void setTransitModes(String value) {
        this.transitModes = Collections.unmodifiableSet(CollectionUtils.stringToSet(value));
    }

    @ReflectiveConfigGroup.StringGetter(value="transitModes")
    private String getTransitModeString() {
        boolean isFirst = true;
        StringBuilder str = new StringBuilder();
        for (String mode : this.transitModes) {
            if (!isFirst) {
                str.append(',');
            }
            str.append(mode);
            isFirst = false;
        }
        return str.toString();
    }

    @Override
    public Map<String, String> getComments() {
        Map<String, String> comments = super.getComments();
        comments.put(TRANSIT_SCHEDULE_FILE, "Input file containing the transit schedule to be simulated.");
        comments.put(VEHICLES_FILE, "Input file containing the vehicles used by the departures in the transit schedule.");
        comments.put(TRANSIT_MODES, "Comma-separated list of transportation modes that are handled as transit. Defaults to 'pt'.");
        comments.put(TRANSIT_LINES_ATTRIBUTES, "Optional input file containing additional attributes for transit lines, stored as ObjectAttributes.");
        comments.put(TRANSIT_STOPS_ATTRIBUTES, "Optional input file containing additional attributes for transit stop facilities, stored as ObjectAttributes.");
        comments.put(USE_TRANSIT, "Set this parameter to true if transit should be simulated, false if not.");
        comments.put(SCHEDULE_CRS, "The Coordinates Reference System in which the coordinates are expressed in the input file. At import, the coordinates will be converted to the coordinate system defined in \"global\", and willbe converted back at export. If not specified, no conversion happens.");
        return comments;
    }

    @ReflectiveConfigGroup.StringSetter(value="transitScheduleFile")
    public void setTransitScheduleFile(String filename) {
        this.testForLocked();
        this.transitScheduleFile = filename;
    }

    @ReflectiveConfigGroup.StringGetter(value="transitScheduleFile")
    public String getTransitScheduleFile() {
        return this.transitScheduleFile;
    }

    public URL getTransitScheduleFileURL(URL context) {
        return ConfigGroup.getInputFileURL(context, this.getTransitScheduleFile());
    }

    @ReflectiveConfigGroup.StringSetter(value="vehiclesFile")
    public void setVehiclesFile(String filename) {
        this.vehiclesFile = filename;
    }

    @ReflectiveConfigGroup.StringGetter(value="vehiclesFile")
    public String getVehiclesFile() {
        return this.vehiclesFile;
    }

    public URL getVehiclesFileURL(URL context) {
        return ConfigGroup.getInputFileURL(context, this.getVehiclesFile());
    }

    public void setTransitModes(Set<String> modes) {
        this.transitModes = Collections.unmodifiableSet(new HashSet<String>(modes));
    }

    public Set<String> getTransitModes() {
        return this.transitModes;
    }

    @ReflectiveConfigGroup.StringGetter(value="transitLinesAttributesFile")
    public String getTransitLinesAttributesFile() {
        return this.transitLinesAttributesFile;
    }

    @ReflectiveConfigGroup.StringSetter(value="transitLinesAttributesFile")
    public void setTransitLinesAttributesFile(String transitLinesAttributesFile) {
        this.transitLinesAttributesFile = transitLinesAttributesFile;
    }

    @ReflectiveConfigGroup.StringGetter(value="transitStopsAttributesFile")
    public String getTransitStopsAttributesFile() {
        return this.transitStopsAttributesFile;
    }

    public URL getTransitStopsAttributesFileURL(URL context) {
        return ConfigGroup.getInputFileURL(context, this.getTransitStopsAttributesFile());
    }

    @ReflectiveConfigGroup.StringSetter(value="transitStopsAttributesFile")
    public void setTransitStopsAttributesFile(String transitStopsAttributesFile) {
        this.transitStopsAttributesFile = transitStopsAttributesFile;
    }

    @ReflectiveConfigGroup.StringGetter(value="useTransit")
    public boolean isUseTransit() {
        return this.useTransit;
    }

    @ReflectiveConfigGroup.StringSetter(value="useTransit")
    public void setUseTransit(boolean val) {
        this.testForLocked();
        this.useTransit = val;
    }

    @ReflectiveConfigGroup.StringGetter(value="inputScheduleCRS")
    public String getInputScheduleCRS() {
        return this.inputScheduleCRS;
    }

    @ReflectiveConfigGroup.StringSetter(value="inputScheduleCRS")
    public void setInputScheduleCRS(String inputScheduleCRS) {
        this.inputScheduleCRS = inputScheduleCRS;
    }

    public BoardingAcceptance getBoardingAcceptance() {
        return this.boardingAcceptance;
    }

    public void setBoardingAcceptance(BoardingAcceptance boardingAcceptance) {
        this.boardingAcceptance = boardingAcceptance;
    }

    public final void setUsingTransitInMobsim(boolean val) {
        this.usingTransitInMobsim = val;
    }

    public final boolean isUsingTransitInMobsim() {
        return this.usingTransitInMobsim;
    }

    public static enum BoardingAcceptance {
        checkLineAndStop,
        checkStopOnly;

    }
}

