/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.pt.config;

import java.util.Map;
import org.matsim.core.config.ReflectiveConfigGroup;

public class TransitRouterConfigGroup
extends ReflectiveConfigGroup {
    public static final String GROUP_NAME = "transitRouter";
    static final String SEARCH_RADIUS = "searchRadius";
    static final String EXTENSION_RADIUS = "extensionRadius";
    static final String MAX_BEELINE_WALK_CONNECTION_DISTANCE = "maxBeelineWalkConnectionDistance";
    static final String ADDITIONAL_TRANSFER_TIME = "additionalTransferTime";
    private double searchRadius = 1000.0;
    private double extensionRadius = 200.0;
    private double maxBeelineWalkConnectionDistance = 100.0;
    private double additionalTransferTime = 0.0;
    private double directWalkFactor = 1.0;
    private boolean cacheTree = false;
    private static final String DIRECT_WALK_FACTOR = "directWalkFactor";
    static final String DIRECT_WALK_FACTOR_CMT = "Factor with which direct walk generalized cost is multiplied before it is compared to the pt generalized cost.  Set to a very high value to reduce direct walk results.";

    public TransitRouterConfigGroup() {
        super(GROUP_NAME);
    }

    @Override
    public Map<String, String> getComments() {
        Map<String, String> comments = super.getComments();
        comments.put(SEARCH_RADIUS, "the radius in which stop locations are searched, given a start or target coordinate");
        comments.put(EXTENSION_RADIUS, "step size to increase searchRadius if no stops are found");
        comments.put(MAX_BEELINE_WALK_CONNECTION_DISTANCE, "maximum beeline distance between stops that agents could transfer to by walking");
        comments.put(ADDITIONAL_TRANSFER_TIME, "additional time the router allocates when a line switch happens. Can be interpreted as a 'safety' time that agents need to safely transfer from one line to another");
        comments.put(DIRECT_WALK_FACTOR, DIRECT_WALK_FACTOR_CMT);
        return comments;
    }

    @ReflectiveConfigGroup.StringSetter(value="searchRadius")
    public void setSearchRadius(double searchRadius) {
        this.testForLocked();
        this.searchRadius = searchRadius;
    }

    @ReflectiveConfigGroup.StringGetter(value="searchRadius")
    public double getSearchRadius() {
        return this.searchRadius;
    }

    @ReflectiveConfigGroup.StringSetter(value="extensionRadius")
    public void setExtensionRadius(double extensionRadius) {
        this.testForLocked();
        this.extensionRadius = extensionRadius;
    }

    @ReflectiveConfigGroup.StringGetter(value="extensionRadius")
    public double getExtensionRadius() {
        return this.extensionRadius;
    }

    @ReflectiveConfigGroup.StringSetter(value="maxBeelineWalkConnectionDistance")
    public void setMaxBeelineWalkConnectionDistance(double maxBeelineWalkConnectionDistance) {
        this.testForLocked();
        this.maxBeelineWalkConnectionDistance = maxBeelineWalkConnectionDistance;
    }

    @ReflectiveConfigGroup.StringGetter(value="maxBeelineWalkConnectionDistance")
    public double getMaxBeelineWalkConnectionDistance() {
        return this.maxBeelineWalkConnectionDistance;
    }

    @ReflectiveConfigGroup.StringSetter(value="additionalTransferTime")
    public void setAdditionalTransferTime(double additionalTransferTime) {
        this.testForLocked();
        this.additionalTransferTime = additionalTransferTime;
    }

    @ReflectiveConfigGroup.StringGetter(value="additionalTransferTime")
    public double getAdditionalTransferTime() {
        return this.additionalTransferTime;
    }

    @ReflectiveConfigGroup.StringGetter(value="directWalkFactor")
    public double getDirectWalkFactor() {
        return this.directWalkFactor;
    }

    @ReflectiveConfigGroup.StringSetter(value="directWalkFactor")
    public final void setDirectWalkFactor(double directWalkFactor) {
        this.directWalkFactor = directWalkFactor;
    }

    public boolean isCacheTree() {
        return this.cacheTree;
    }

    public void setCacheTree(boolean cacheTree) {
        this.cacheTree = cacheTree;
    }
}

