/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.pt.counts;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.events.PersonEntersVehicleEvent;
import org.matsim.api.core.v01.events.PersonLeavesVehicleEvent;
import org.matsim.api.core.v01.events.TransitDriverStartsEvent;
import org.matsim.api.core.v01.events.handler.PersonEntersVehicleEventHandler;
import org.matsim.api.core.v01.events.handler.PersonLeavesVehicleEventHandler;
import org.matsim.api.core.v01.events.handler.TransitDriverStartsEventHandler;
import org.matsim.api.core.v01.population.Person;
import org.matsim.core.api.experimental.events.VehicleArrivesAtFacilityEvent;
import org.matsim.core.api.experimental.events.VehicleDepartsAtFacilityEvent;
import org.matsim.core.api.experimental.events.handler.VehicleArrivesAtFacilityEventHandler;
import org.matsim.core.api.experimental.events.handler.VehicleDepartsAtFacilityEventHandler;
import org.matsim.pt.counts.SimpleWriter;
import org.matsim.pt.transitSchedule.api.TransitStopFacility;
import org.matsim.vehicles.Vehicle;

public class OccupancyAnalyzer
implements PersonEntersVehicleEventHandler,
PersonLeavesVehicleEventHandler,
VehicleArrivesAtFacilityEventHandler,
VehicleDepartsAtFacilityEventHandler,
TransitDriverStartsEventHandler {
    private static final Logger log = Logger.getLogger(OccupancyAnalyzer.class);
    private final int timeBinSize;
    private final int maxSlotIndex;
    private final double maxTime;
    private Map<Id<TransitStopFacility>, int[]> boards;
    private Map<Id<TransitStopFacility>, int[]> alights;
    private Map<Id<TransitStopFacility>, int[]> occupancies;
    private final Map<Id<Vehicle>, Id<TransitStopFacility>> vehStops = new HashMap<Id<Vehicle>, Id<TransitStopFacility>>();
    private final Map<Id<Vehicle>, Integer> vehPassengers = new HashMap<Id<Vehicle>, Integer>();
    private StringBuffer occupancyRecord = new StringBuffer("time\tvehId\tStopId\tno.ofPassengersInVeh\n");
    private final Set<Id<Person>> transitDrivers = new HashSet<Id<Person>>();
    private final Set<Id<Vehicle>> transitVehicles = new HashSet<Id<Vehicle>>();

    public OccupancyAnalyzer(int timeBinSize, double maxTime) {
        log.setLevel(Level.INFO);
        this.timeBinSize = timeBinSize;
        this.maxTime = maxTime;
        this.maxSlotIndex = (int)this.maxTime / this.timeBinSize + 1;
        this.boards = new HashMap<Id<TransitStopFacility>, int[]>();
        this.alights = new HashMap<Id<TransitStopFacility>, int[]>();
        this.occupancies = new HashMap<Id<TransitStopFacility>, int[]>();
    }

    public void setBoards(Map<Id<TransitStopFacility>, int[]> boards) {
        this.boards = boards;
    }

    public void setAlights(Map<Id<TransitStopFacility>, int[]> alights) {
        this.alights = alights;
    }

    public void setOccupancies(Map<Id<TransitStopFacility>, int[]> occupancies) {
        this.occupancies = occupancies;
    }

    public int getTimeSlotIndex(double time) {
        if (time > this.maxTime) {
            return this.maxSlotIndex;
        }
        return (int)time / this.timeBinSize;
    }

    @Override
    public void reset(int iteration) {
        this.boards.clear();
        this.alights.clear();
        this.occupancies.clear();
        this.vehStops.clear();
        this.vehPassengers.clear();
        this.occupancyRecord = new StringBuffer("time\tvehId\tStopId\tno.ofPassengersInVeh\n");
        this.transitDrivers.clear();
        this.transitVehicles.clear();
    }

    @Override
    public void handleEvent(TransitDriverStartsEvent event) {
        this.transitDrivers.add(event.getDriverId());
        this.transitVehicles.add(event.getVehicleId());
    }

    @Override
    public void handleEvent(PersonEntersVehicleEvent event) {
        if (this.transitDrivers.contains(event.getPersonId()) || !this.transitVehicles.contains(event.getVehicleId())) {
            return;
        }
        Id<Vehicle> vehId = event.getVehicleId();
        Id<TransitStopFacility> stopId = this.vehStops.get(vehId);
        double time = event.getTime();
        int[] getOn = this.boards.get(stopId);
        if (getOn == null) {
            getOn = new int[this.maxSlotIndex + 1];
            this.boards.put(stopId, getOn);
        }
        int n = this.getTimeSlotIndex(time);
        getOn[n] = getOn[n] + 1;
        Integer nPassengers = this.vehPassengers.get(vehId);
        this.vehPassengers.put(vehId, nPassengers != null ? nPassengers + 1 : 1);
        this.occupancyRecord.append("time :\t").append(time).append(" veh :\t").append(vehId).append(" has Passenger\t").append(this.vehPassengers.get(vehId)).append(" \tat stop :\t").append(stopId).append(" ENTERING PERSON :\t").append(event.getPersonId()).append("\n");
    }

    @Override
    public void handleEvent(PersonLeavesVehicleEvent event) {
        if (this.transitDrivers.contains(event.getPersonId()) || !this.transitVehicles.contains(event.getVehicleId())) {
            return;
        }
        Id<Vehicle> vehId = event.getVehicleId();
        Id<TransitStopFacility> stopId = this.vehStops.get(vehId);
        double time = event.getTime();
        int[] getDown = this.alights.get(stopId);
        if (getDown == null) {
            getDown = new int[this.maxSlotIndex + 1];
            this.alights.put(stopId, getDown);
        }
        int n = this.getTimeSlotIndex(time);
        getDown[n] = getDown[n] + 1;
        Integer nPassengers = this.vehPassengers.get(vehId);
        if (nPassengers == null) {
            log.error("tests for `null' but exception says 'negative'???  kai, oct'10 ");
            throw new RuntimeException("negative passenger-No. in vehicle?");
        }
        this.vehPassengers.put(vehId, nPassengers - 1);
        if (this.vehPassengers.get(vehId) == 0) {
            this.vehPassengers.remove(vehId);
        }
        Integer passengers = this.vehPassengers.get(vehId);
        this.occupancyRecord.append("time :\t").append(time).append(" veh :\t").append(vehId).append(" has Passenger\t").append(passengers != null ? passengers : 0).append("\n");
    }

    @Override
    public void handleEvent(VehicleArrivesAtFacilityEvent event) {
        Id<TransitStopFacility> stopId = event.getFacilityId();
        this.vehStops.put(event.getVehicleId(), stopId);
    }

    @Override
    public void handleEvent(VehicleDepartsAtFacilityEvent event) {
        Integer noPassengersInVeh;
        Id<TransitStopFacility> stopId = event.getFacilityId();
        Id<Vehicle> vehId = event.getVehicleId();
        this.vehStops.remove(vehId);
        int[] occupancyAtStop = this.occupancies.get(stopId);
        if (occupancyAtStop == null) {
            occupancyAtStop = new int[this.maxSlotIndex + 1];
            this.occupancies.put(stopId, occupancyAtStop);
        }
        if ((noPassengersInVeh = this.vehPassengers.get(vehId)) != null) {
            int n = this.getTimeSlotIndex(event.getTime());
            occupancyAtStop[n] = occupancyAtStop[n] + noPassengersInVeh;
            this.occupancyRecord.append(event.getTime());
            this.occupancyRecord.append("\t");
            this.occupancyRecord.append(vehId);
            this.occupancyRecord.append("\t");
            this.occupancyRecord.append(stopId);
            this.occupancyRecord.append("\t");
            this.occupancyRecord.append(noPassengersInVeh);
            this.occupancyRecord.append("\n");
        }
    }

    public int[] getBoardVolumesForStop(Id<TransitStopFacility> stopId) {
        int[] values = this.boards.get(stopId);
        if (values == null) {
            return new int[this.maxSlotIndex + 1];
        }
        return values;
    }

    public int[] getAlightVolumesForStop(Id<TransitStopFacility> stopId) {
        int[] values = this.alights.get(stopId);
        if (values == null) {
            return new int[this.maxSlotIndex + 1];
        }
        return values;
    }

    public int[] getOccupancyVolumesForStop(Id<TransitStopFacility> stopId) {
        int[] values = this.occupancies.get(stopId);
        if (values == null) {
            return new int[this.maxSlotIndex + 1];
        }
        return values;
    }

    public Set<Id<TransitStopFacility>> getBoardStopIds() {
        return this.boards.keySet();
    }

    public Set<Id<TransitStopFacility>> getAlightStopIds() {
        return this.alights.keySet();
    }

    public Set<Id<TransitStopFacility>> getOccupancyStopIds() {
        return this.occupancies.keySet();
    }

    public Set<Id<TransitStopFacility>> getAllStopIds() {
        TreeSet<Id<TransitStopFacility>> allStopIds = new TreeSet<Id<TransitStopFacility>>();
        allStopIds.addAll(this.getBoardStopIds());
        allStopIds.addAll(this.getAlightStopIds());
        allStopIds.addAll(this.getOccupancyStopIds());
        return allStopIds;
    }

    public void write(String filename) {
        int i;
        SimpleWriter writer = new SimpleWriter(filename);
        writer.write("stopId\t");
        for (i = 0; i < 24; ++i) {
            writer.write("bo" + i + "-" + (i + 1) + "\t");
        }
        for (i = 0; i < 24; ++i) {
            writer.write("al" + i + "-" + (i + 1) + "\t");
        }
        for (i = 0; i < 24; ++i) {
            writer.write("oc" + i + "-" + (i + 1) + "\t");
        }
        writer.writeln();
        for (Id<TransitStopFacility> stopId : this.getAllStopIds()) {
            writer.write(stopId + "\t");
            int[] board = this.boards.get(stopId);
            if (board == null) {
                log.debug("stopId:\t" + stopId + "\thas null boards!");
            }
            for (int i2 = 0; i2 < 24; ++i2) {
                writer.write((board != null ? board[i2] : 0) + "\t");
            }
            int[] alight = this.alights.get(stopId);
            if (alight == null) {
                log.debug("stopId:\t" + stopId + "\thas null alights!");
            }
            for (int i3 = 0; i3 < 24; ++i3) {
                writer.write((alight != null ? alight[i3] : 0) + "\t");
            }
            int[] ocuppancy = this.occupancies.get(stopId);
            if (ocuppancy == null) {
                log.debug("stopId:\t" + stopId + "\tthere aren't passengers in Bus after the transfer!");
            }
            for (int i4 = 0; i4 < 24; ++i4) {
                writer.write((ocuppancy != null ? ocuppancy[i4] : 0) + "\t");
            }
            writer.writeln();
        }
        writer.write(this.occupancyRecord.toString());
        writer.close();
    }
}

