/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.pt.counts;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.matsim.analysis.IterationStopWatch;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Network;
import org.matsim.core.api.experimental.events.EventsManager;
import org.matsim.core.config.Config;
import org.matsim.core.config.groups.PtCountsConfigGroup;
import org.matsim.core.controler.OutputDirectoryHierarchy;
import org.matsim.core.controler.events.AfterMobsimEvent;
import org.matsim.core.controler.events.BeforeMobsimEvent;
import org.matsim.core.controler.events.IterationEndsEvent;
import org.matsim.core.controler.events.StartupEvent;
import org.matsim.core.controler.listener.AfterMobsimListener;
import org.matsim.core.controler.listener.BeforeMobsimListener;
import org.matsim.core.controler.listener.IterationEndsListener;
import org.matsim.core.controler.listener.StartupListener;
import org.matsim.core.utils.geometry.CoordinateTransformation;
import org.matsim.core.utils.geometry.transformations.TransformationFactory;
import org.matsim.counts.CountSimComparison;
import org.matsim.counts.Counts;
import org.matsim.counts.MatsimCountsReader;
import org.matsim.counts.algorithms.CountSimComparisonKMLWriter;
import org.matsim.counts.algorithms.CountsComparisonAlgorithm;
import org.matsim.pt.counts.OccupancyAnalyzer;
import org.matsim.pt.counts.PtCountSimComparisonTableWriter;
import org.matsim.pt.transitSchedule.api.TransitStopFacility;

public class PtCountControlerListener
implements StartupListener,
IterationEndsListener,
BeforeMobsimListener,
AfterMobsimListener {
    private EventsManager eventsManager;
    private OutputDirectoryHierarchy controlerIO;
    private IterationStopWatch iterationStopWatch;
    private Network network;
    private static final Logger log = Logger.getLogger(PtCountControlerListener.class);
    public static final String OPERATION_COMPAREPTCOUNTS = "compare with pt counts";
    private static final String MODULE_NAME = "ptCounts";
    private final Config config;
    private final Counts boardCounts;
    private final Counts alightCounts;
    private final Counts occupancyCounts;
    private final OccupancyAnalyzer occupancyAnalyzer;

    @Inject
    PtCountControlerListener(Config config, EventsManager eventsManager, OutputDirectoryHierarchy controlerIO, IterationStopWatch iterationStopWatch, Network network) {
        this.eventsManager = eventsManager;
        this.controlerIO = controlerIO;
        this.iterationStopWatch = iterationStopWatch;
        this.network = network;
        log.info("Using pt counts.");
        this.config = config;
        this.boardCounts = new Counts();
        this.alightCounts = new Counts();
        this.occupancyCounts = new Counts();
        this.occupancyAnalyzer = new OccupancyAnalyzer(3600, 86399.0);
    }

    @Override
    public void notifyStartup(StartupEvent controlerStartupEvent) {
        PtCountsConfigGroup ptCounts = this.config.ptCounts();
        String boardCountsFilename = ptCounts.getBoardCountsFileName();
        String alightCountsFilename = ptCounts.getAlightCountsFileName();
        String occupancyCountsFilename = ptCounts.getOccupancyCountsFileName();
        if (boardCountsFilename == null || alightCountsFilename == null || occupancyCountsFilename == null) {
            throw new RuntimeException("for pt counts, at this point all three files must be given!");
        }
        new MatsimCountsReader(this.alightCounts).readFile(alightCountsFilename);
        new MatsimCountsReader(this.boardCounts).readFile(boardCountsFilename);
        new MatsimCountsReader(this.occupancyCounts).readFile(occupancyCountsFilename);
    }

    @Override
    public void notifyBeforeMobsim(BeforeMobsimEvent event) {
        int iter = event.getIteration();
        if (this.isActiveInThisIteration(iter)) {
            this.occupancyAnalyzer.reset(iter);
            this.eventsManager.addHandler(this.occupancyAnalyzer);
        }
    }

    @Override
    public void notifyAfterMobsim(AfterMobsimEvent event) {
        int it = event.getIteration();
        if (this.isActiveInThisIteration(it)) {
            this.eventsManager.removeHandler(this.occupancyAnalyzer);
            this.occupancyAnalyzer.write(this.controlerIO.getIterationFilename(it, "occupancyAnalysis.txt"));
        }
    }

    private boolean isActiveInThisIteration(int iter) {
        return iter % this.config.ptCounts().getPtCountsInterval() == 0 && iter >= this.config.controler().getFirstIteration();
    }

    @Override
    public void notifyIterationEnds(IterationEndsEvent event) {
        int iter = event.getIteration();
        if (this.isActiveInThisIteration(iter)) {
            this.iterationStopWatch.beginOperation(OPERATION_COMPAREPTCOUNTS);
            double countsScaleFactor = Double.parseDouble(this.config.getParam(MODULE_NAME, "countsScaleFactor"));
            HashMap<CountType, CountsComparisonAlgorithm> cca = new HashMap<CountType, CountsComparisonAlgorithm>();
            cca.put(CountType.Boarding, new CountsComparisonAlgorithm(new CountsComparisonAlgorithm.VolumesForId(){

                @Override
                public double[] getVolumesForStop(Id<TransitStopFacility> locationId) {
                    return PtCountControlerListener.copyFromIntArray(PtCountControlerListener.this.occupancyAnalyzer.getBoardVolumesForStop(locationId));
                }
            }, (Counts<Link>)this.boardCounts, this.network, countsScaleFactor));
            cca.put(CountType.Alighting, new CountsComparisonAlgorithm(new CountsComparisonAlgorithm.VolumesForId(){

                @Override
                public double[] getVolumesForStop(Id<TransitStopFacility> locationId) {
                    return PtCountControlerListener.copyFromIntArray(PtCountControlerListener.this.occupancyAnalyzer.getAlightVolumesForStop(locationId));
                }
            }, (Counts<Link>)this.alightCounts, this.network, countsScaleFactor));
            cca.put(CountType.Occupancy, new CountsComparisonAlgorithm(new CountsComparisonAlgorithm.VolumesForId(){

                @Override
                public double[] getVolumesForStop(Id<TransitStopFacility> locationId) {
                    return PtCountControlerListener.copyFromIntArray(PtCountControlerListener.this.occupancyAnalyzer.getOccupancyVolumesForStop(locationId));
                }
            }, (Counts<Link>)this.occupancyCounts, this.network, countsScaleFactor));
            String distanceFilterStr = this.config.findParam(MODULE_NAME, "distanceFilter");
            String distanceFilterCenterNodeId = this.config.findParam(MODULE_NAME, "distanceFilterCenterNode");
            if (distanceFilterStr != null && distanceFilterCenterNodeId != null) {
                for (CountsComparisonAlgorithm algo : cca.values()) {
                    algo.setCountCoordUsingDistanceFilter(Double.parseDouble(distanceFilterStr), distanceFilterCenterNodeId);
                }
            }
            for (CountsComparisonAlgorithm algo : cca.values()) {
                algo.setCountsScaleFactor(countsScaleFactor);
                algo.run();
            }
            String outputFormat = this.config.findParam(MODULE_NAME, "outputformat");
            if (outputFormat.contains("kml") || outputFormat.contains("all")) {
                String filename = this.controlerIO.getIterationFilename(iter, "ptcountscompare.kmz");
                HashMap<CountType, List<CountSimComparison>> comparisons = new HashMap<CountType, List<CountSimComparison>>();
                for (CountType countType : CountType.values()) {
                    if (cca.get((Object)countType) == null) continue;
                    comparisons.put(countType, ((CountsComparisonAlgorithm)cca.get((Object)countType)).getComparison());
                }
                CoordinateTransformation coordTransform = TransformationFactory.getCoordinateTransformation(this.config.global().getCoordinateSystem(), "WGS84");
                CountSimComparisonKMLWriter kmlWriter = new CountSimComparisonKMLWriter((List)comparisons.get((Object)CountType.Occupancy), this.occupancyCounts, coordTransform, "ptCountsOccup");
                kmlWriter.setIterationNumber(iter);
                kmlWriter.writeFile(filename);
            }
            if (outputFormat.contains("txt") || outputFormat.contains("all")) {
                for (Map.Entry entry : cca.entrySet()) {
                    CountsComparisonAlgorithm algo = (CountsComparisonAlgorithm)entry.getValue();
                    new PtCountSimComparisonTableWriter(algo.getComparison()).write(this.controlerIO.getIterationFilename(iter, "simCountCompare" + ((CountType)((Object)entry.getKey())).toString() + ".txt"));
                }
            }
            this.iterationStopWatch.endOperation(OPERATION_COMPAREPTCOUNTS);
        }
    }

    private static double[] copyFromIntArray(int[] source) {
        double[] dest = new double[source.length];
        for (int i = 0; i < source.length; ++i) {
            dest[i] = source[i];
        }
        return dest;
    }

    private static enum CountType {
        Boarding,
        Alighting,
        Occupancy;

    }
}

