/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.pt.counts;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.matsim.api.core.v01.Id;
import org.matsim.counts.CountSimComparison;
import org.matsim.counts.algorithms.graphs.CountsGraph;
import org.matsim.counts.algorithms.graphs.CountsGraphsCreator;
import org.matsim.counts.algorithms.graphs.CountsLoadCurveGraph;
import org.matsim.counts.algorithms.graphs.helper.MyURL;

public class PtCountsLoadCurveGraphCreator
extends CountsGraphsCreator {
    public PtCountsLoadCurveGraphCreator(String sectionTitle) {
        super(sectionTitle);
    }

    @Override
    public List<CountsGraph> createGraphs(List<CountSimComparison> ccl, int iteration) {
        Vector<CountsGraph> graphList = new Vector<CountsGraph>();
        Iterator<CountSimComparison> l_it = ccl.iterator();
        CountSimComparison cc_last = null;
        while (l_it.hasNext()) {
            CountsLoadCurveGraph lcg = new CountsLoadCurveGraph(ccl, iteration, "dummy");
            if (cc_last != null) {
                lcg.add2LoadCurveDataSets(cc_last);
            }
            CountSimComparison cc = l_it.next();
            Id stopId = cc.getId();
            while (cc.getId().equals(stopId)) {
                if (l_it.hasNext()) {
                    lcg.add2LoadCurveDataSets(cc);
                    cc = l_it.next();
                    continue;
                }
                lcg.add2LoadCurveDataSets(cc);
                break;
            }
            lcg.setChartTitle("Stop " + stopId);
            lcg.setFilename("stop" + stopId);
            lcg.setLinkId(stopId.toString());
            lcg.createChart(0);
            graphList.add(lcg);
            this.section.addURL(new MyURL("stop" + stopId + ".html", "stop" + stopId));
            cc_last = cc;
        }
        return graphList;
    }
}

