/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.pt.counts;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import org.matsim.core.utils.io.IOUtils;
import org.matsim.core.utils.io.UncheckedIOException;

public class SimpleWriter
implements Closeable,
Flushable {
    private final BufferedWriter writer;

    public SimpleWriter(String outputFilename) {
        this.writer = IOUtils.getBufferedWriter(outputFilename);
    }

    public void write(char[] c) {
        if (this.writer != null) {
            try {
                this.writer.write(c);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    public void write(char c) {
        if (this.writer != null) {
            try {
                this.writer.write(c);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    public void write(String s2) {
        if (this.writer != null) {
            try {
                this.writer.write(s2);
            }
            catch (IOException e) {
                System.err.println("writer was not initialized yet!");
                throw new UncheckedIOException(e);
            }
        }
    }

    public void write(Object o) {
        this.write(o.toString());
    }

    public void writeln(String s2) {
        this.write(s2 + "\n");
    }

    public void writeln(Object o) {
        this.write(o + "\n");
    }

    public void writeln() {
        this.write('\n');
    }

    @Override
    public void close() {
        try {
            this.writer.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void flush() {
        try {
            this.writer.flush();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void writeln(StringBuffer line) {
        this.writeln(line.toString());
    }
}

