/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.pt.counts.obsolete;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.opengis.kml.v_2_2_0.DocumentType;
import net.opengis.kml.v_2_2_0.FolderType;
import net.opengis.kml.v_2_2_0.IconStyleType;
import net.opengis.kml.v_2_2_0.KmlType;
import net.opengis.kml.v_2_2_0.LinkType;
import net.opengis.kml.v_2_2_0.ObjectFactory;
import net.opengis.kml.v_2_2_0.PlacemarkType;
import net.opengis.kml.v_2_2_0.PointType;
import net.opengis.kml.v_2_2_0.ScreenOverlayType;
import net.opengis.kml.v_2_2_0.StyleType;
import net.opengis.kml.v_2_2_0.TimeSpanType;
import net.opengis.kml.v_2_2_0.UnitsEnumType;
import net.opengis.kml.v_2_2_0.Vec2Type;
import org.apache.log4j.Logger;
import org.jfree.chart.ChartUtils;
import org.jfree.chart.JFreeChart;
import org.matsim.api.core.v01.Coord;
import org.matsim.api.core.v01.Id;
import org.matsim.core.gbl.MatsimResource;
import org.matsim.core.utils.geometry.CoordinateTransformation;
import org.matsim.core.utils.io.IOUtils;
import org.matsim.core.utils.misc.Time;
import org.matsim.counts.Count;
import org.matsim.counts.CountSimComparison;
import org.matsim.counts.Counts;
import org.matsim.counts.algorithms.graphs.CountsGraph;
import org.matsim.counts.algorithms.graphs.CountsLoadCurveGraph;
import org.matsim.pt.counts.PtCountsLoadCurveGraphCreator;
import org.matsim.pt.counts.obsolete.PtBiasErrorGraph;
import org.matsim.pt.counts.obsolete.PtCountSimComparisonWriter;
import org.matsim.pt.counts.obsolete.PtCountsSimRealPerHourGraph;
import org.matsim.vis.kml.KMZWriter;
import org.matsim.vis.kml.MatsimKMLLogo;

@Deprecated
public final class PtCountSimComparisonKMLWriter
extends PtCountSimComparisonWriter {
    private static final String STOP = "Stop: ";
    private static final String COUNTVALUE = "Count Value: ";
    private static final String MATSIMVALUE = "MATSim Value: ";
    private static final String RELERROR = "Relative Error: ";
    private static final String IMG = "<img src=\"./";
    private static final String IMGEND = "\">";
    private static final String H24OVERVIEW = "24 h overview";
    private static final String DETAILSFROM = "Details from ";
    private static final String OCLOCKTO = " o'clock to ";
    private static final String OCLOCK = " o'clock";
    private static final String ZERO = "0";
    private static final String CROSSICON = "icons/plus.png";
    private static final String MINUSICON = "icons/minus.png";
    private static final Double ICONSCALE = 0.5;
    private static final int CHARTHEIGHT = 300;
    private static final int CHARTWIDTH = 400;
    private static final String PNG = ".png";
    private static final String SIMREALGRAPHNAME = "countsSimRealPerHour_";
    private CoordinateTransformation coordTransform = null;
    private ObjectFactory kmlObjectFactory = new ObjectFactory();
    private KmlType mainKml = null;
    private DocumentType mainDoc = null;
    private FolderType mainFolder = null;
    private KMZWriter writer = null;
    private StyleType redCrossStyle;
    private StyleType redMinusStyle;
    private StyleType yellowCrossStyle;
    private StyleType yellowMinusStyle;
    private StyleType greenMinusStyle;
    private StyleType greenCrossStyle;
    private StyleType greyCrossStyle;
    private StyleType greyMinusStyle;
    private Map<String, String> boardCountsLoadCurveGraphMap;
    private Map<String, String> alightCountsLoadCurveGraphMap;
    private Map<String, String> occupancyCountsLoadCurveGraphMap;
    private Counts boardCounts;
    private Counts alightCounts;
    private Counts occupancyCounts;
    private static final Logger log = Logger.getLogger(PtCountSimComparisonKMLWriter.class);

    @Deprecated
    public PtCountSimComparisonKMLWriter(List<CountSimComparison> boardCountSimCompList, List<CountSimComparison> alightCountSimCompList, List<CountSimComparison> occupancyCountSimCompList, CoordinateTransformation coordTransform, Counts boradCounts, Counts alightCounts, Counts occupancyCounts) {
        super(boardCountSimCompList, alightCountSimCompList, occupancyCountSimCompList);
        this.coordTransform = coordTransform;
        this.boardCounts = boradCounts;
        this.alightCounts = alightCounts;
        this.occupancyCounts = occupancyCounts;
    }

    private void createStyles() {
        this.redCrossStyle = this.kmlObjectFactory.createStyleType();
        this.redCrossStyle.setId("redCrossStyle");
        this.redMinusStyle = this.kmlObjectFactory.createStyleType();
        this.redMinusStyle.setId("redMinusStyle");
        this.yellowCrossStyle = this.kmlObjectFactory.createStyleType();
        this.yellowCrossStyle.setId("yellowCrossStyle");
        this.yellowMinusStyle = this.kmlObjectFactory.createStyleType();
        this.yellowMinusStyle.setId("yellowMinusStyle");
        this.greenCrossStyle = this.kmlObjectFactory.createStyleType();
        this.greenCrossStyle.setId("greenCrossStyle");
        this.greenMinusStyle = this.kmlObjectFactory.createStyleType();
        this.greenMinusStyle.setId("greenMinusStyle");
        this.greyCrossStyle = this.kmlObjectFactory.createStyleType();
        this.greyCrossStyle.setId("greyCrossStyle");
        this.greyMinusStyle = this.kmlObjectFactory.createStyleType();
        this.greyMinusStyle.setId("greyMinusStyle");
        byte[] red = new byte[]{-1, 15, 15, -66};
        byte[] green = new byte[]{-1, 20, -36, 10};
        byte[] yellow = new byte[]{-1, 20, -26, -26};
        byte[] grey = new byte[]{-1, 66, 66, 66};
        HashMap<StyleType, byte[]> colors = new HashMap<StyleType, byte[]>();
        colors.put(this.redCrossStyle, red);
        colors.put(this.redMinusStyle, red);
        colors.put(this.yellowCrossStyle, yellow);
        colors.put(this.yellowMinusStyle, yellow);
        colors.put(this.greenCrossStyle, green);
        colors.put(this.greenMinusStyle, green);
        colors.put(this.greyCrossStyle, grey);
        colors.put(this.greyMinusStyle, grey);
        HashMap<StyleType, String> hrefs = new HashMap<StyleType, String>();
        hrefs.put(this.redCrossStyle, CROSSICON);
        hrefs.put(this.redMinusStyle, MINUSICON);
        hrefs.put(this.yellowCrossStyle, CROSSICON);
        hrefs.put(this.yellowMinusStyle, MINUSICON);
        hrefs.put(this.greenCrossStyle, CROSSICON);
        hrefs.put(this.greenMinusStyle, MINUSICON);
        hrefs.put(this.greyCrossStyle, CROSSICON);
        hrefs.put(this.greyMinusStyle, MINUSICON);
        for (StyleType styleType : new StyleType[]{this.redCrossStyle, this.redMinusStyle, this.yellowCrossStyle, this.yellowMinusStyle, this.greenCrossStyle, this.greenMinusStyle, this.greyCrossStyle, this.greyMinusStyle}) {
            IconStyleType icon = this.kmlObjectFactory.createIconStyleType();
            icon.setColor(new byte[]{((byte[])colors.get(styleType))[0], ((byte[])colors.get(styleType))[1], ((byte[])colors.get(styleType))[2], ((byte[])colors.get(styleType))[3]});
            icon.setScale(ICONSCALE);
            if (styleType == this.redCrossStyle || styleType == this.redMinusStyle) {
                icon.setScale(ICONSCALE);
            }
            LinkType link = this.kmlObjectFactory.createLinkType();
            link.setHref((String)hrefs.get(styleType));
            icon.setIcon(link);
            styleType.setIconStyle(icon);
            this.mainDoc.getAbstractStyleSelectorGroup().add(this.kmlObjectFactory.createStyle(styleType));
        }
    }

    @Override
    @Deprecated
    public void writeFile(String filename) {
        this.mainKml = this.kmlObjectFactory.createKmlType();
        this.mainDoc = this.kmlObjectFactory.createDocumentType();
        this.mainKml.setAbstractFeatureGroup(this.kmlObjectFactory.createDocument(this.mainDoc));
        this.createStyles();
        this.mainFolder = this.kmlObjectFactory.createFolderType();
        this.mainFolder.setName("Comparison, Iteration " + this.iter);
        this.mainDoc.getAbstractFeatureGroup().add(this.kmlObjectFactory.createFolder(this.mainFolder));
        this.writer = new KMZWriter(filename);
        try {
            this.mainFolder.getAbstractFeatureGroup().add(this.kmlObjectFactory.createScreenOverlay(this.createLegend()));
        }
        catch (IOException e) {
            log.error("Cannot add legend to the KMZ file.", e);
        }
        try {
            this.mainFolder.getAbstractFeatureGroup().add(this.kmlObjectFactory.createScreenOverlay(MatsimKMLLogo.writeMatsimKMLLogo(this.writer)));
        }
        catch (IOException e) {
            log.error("Cannot add logo to the KMZ file.", e);
        }
        try {
            this.writer.addNonKMLFile(MatsimResource.getAsInputStream(CROSSICON), CROSSICON);
            this.writer.addNonKMLFile(MatsimResource.getAsInputStream(MINUSICON), MINUSICON);
        }
        catch (IOException e) {
            log.error("Could not copy copy plus-/minus-icons to the KMZ.", e);
        }
        FolderType simRealFolder = this.kmlObjectFactory.createFolderType();
        simRealFolder.setName("XY Comparison Plots");
        this.mainFolder.getAbstractFeatureGroup().add(this.kmlObjectFactory.createFolder(simRealFolder));
        ScreenOverlayType errorGraphBoard = this.createBiasErrorGraph(PtCountSimComparisonWriter.PtCountsType.Boarding, filename);
        errorGraphBoard.setVisibility(Boolean.TRUE);
        this.mainFolder.getAbstractFeatureGroup().add(this.kmlObjectFactory.createScreenOverlay(errorGraphBoard));
        ScreenOverlayType errorGraphAlight = this.createBiasErrorGraph(PtCountSimComparisonWriter.PtCountsType.Alighting, filename);
        errorGraphAlight.setVisibility(Boolean.TRUE);
        this.mainFolder.getAbstractFeatureGroup().add(this.kmlObjectFactory.createScreenOverlay(errorGraphAlight));
        ScreenOverlayType errorGraphOccupancy = this.createBiasErrorGraph(PtCountSimComparisonWriter.PtCountsType.Occupancy, filename);
        errorGraphOccupancy.setVisibility(Boolean.TRUE);
        this.mainFolder.getAbstractFeatureGroup().add(this.kmlObjectFactory.createScreenOverlay(errorGraphOccupancy));
        this.createCountsLoadCurveGraphs();
        for (int h2 = 1; h2 < 25; ++h2) {
            TimeSpanType timespan = this.kmlObjectFactory.createTimeSpanType();
            timespan.setBegin("1999-01-01T" + Time.writeTime((h2 - 1) * 3600));
            timespan.setEnd("1999-01-01T" + Time.writeTime(h2 * 3600));
            this.addCountsSimRealPerHourGraphs(simRealFolder, h2, timespan);
            FolderType subfolder = this.kmlObjectFactory.createFolderType();
            subfolder.setName(this.createFolderName(h2));
            subfolder.setAbstractTimePrimitiveGroup(this.kmlObjectFactory.createTimeSpan(timespan));
            this.mainFolder.getAbstractFeatureGroup().add(this.kmlObjectFactory.createFolder(subfolder));
            if (this.boardCountComparisonFilter != null) {
                this.writeStopData(this.boardCountComparisonFilter.getCountsForHour(h2), subfolder, PtCountSimComparisonWriter.PtCountsType.Boarding);
            }
            if (this.alightCountComparisonFilter != null) {
                this.writeStopData(this.alightCountComparisonFilter.getCountsForHour(h2), subfolder, PtCountSimComparisonWriter.PtCountsType.Alighting);
            }
            if (this.occupancyCountComparisonFilter == null) continue;
            this.writeStopData(this.occupancyCountComparisonFilter.getCountsForHour(h2), subfolder, PtCountSimComparisonWriter.PtCountsType.Occupancy);
        }
        this.finish();
    }

    private String createFolderName(int timestep) {
        StringBuilder buffer = new StringBuilder(30);
        buffer.append("Traffic from ");
        buffer.append(this.timestepToString(timestep - 1));
        buffer.append(" to ");
        buffer.append(this.timestepToString(timestep));
        buffer.append(OCLOCK);
        return buffer.toString();
    }

    private ScreenOverlayType createLegend() throws IOException {
        this.writer.addNonKMLFile(MatsimResource.getAsInputStream("countsKml/countsLegend240x300.png"), "countsLegend.png");
        ScreenOverlayType overlay = this.kmlObjectFactory.createScreenOverlayType();
        LinkType icon = this.kmlObjectFactory.createLinkType();
        icon.setHref("./countsLegend.png");
        overlay.setIcon(icon);
        overlay.setName("Legend");
        Vec2Type overlayXY = this.kmlObjectFactory.createVec2Type();
        overlayXY.setX(0.0);
        overlayXY.setY(0.0);
        overlayXY.setXunits(UnitsEnumType.FRACTION);
        overlayXY.setYunits(UnitsEnumType.FRACTION);
        overlay.setOverlayXY(overlayXY);
        Vec2Type screenXY = this.kmlObjectFactory.createVec2Type();
        screenXY.setX(0.02);
        screenXY.setY(0.07);
        screenXY.setXunits(UnitsEnumType.FRACTION);
        screenXY.setYunits(UnitsEnumType.FRACTION);
        overlay.setScreenXY(screenXY);
        return overlay;
    }

    private PlacemarkType createPlacemark(String stopid, CountSimComparison csc, double relativeError, int timestep, PtCountSimComparisonWriter.PtCountsType type) {
        StringBuilder stringBuffer = new StringBuilder();
        PlacemarkType placemark = this.kmlObjectFactory.createPlacemarkType();
        stringBuffer.delete(0, stringBuffer.length());
        stringBuffer.append(STOP);
        stringBuffer.append(stopid);
        placemark.setDescription(this.createPlacemarkDescription(stopid, csc, relativeError, timestep, type));
        return placemark;
    }

    private void writeStopData(List<CountSimComparison> countSimComparisonList, FolderType folder, PtCountSimComparisonWriter.PtCountsType type) {
        for (CountSimComparison csc : countSimComparisonList) {
            Count count;
            Id stopid = csc.getId();
            switch (type) {
                case Boarding: {
                    count = this.boardCounts.getCount(stopid);
                    break;
                }
                case Alighting: {
                    count = this.alightCounts.getCount(stopid);
                    break;
                }
                default: {
                    count = this.occupancyCounts.getCount(stopid);
                }
            }
            Coord coord = this.coordTransform.transform(count.getCoord());
            double relativeError = csc.calculateRelativeError() * 100.0;
            PlacemarkType placemark = this.createPlacemark(stopid.toString(), csc, relativeError, csc.getHour(), type);
            PointType point = this.kmlObjectFactory.createPointType();
            point.getCoordinates().add(Double.toString(coord.getX()) + "," + Double.toString(coord.getY()) + ",0.0");
            placemark.setAbstractGeometryGroup(this.kmlObjectFactory.createPoint(point));
            if (csc.getSimulationValue() > csc.getCountValue()) {
                if (csc.getSimulationValue() < csc.getCountValue() * 1.5) {
                    placemark.setStyleUrl(this.greenCrossStyle.getId());
                } else if (csc.getSimulationValue() < csc.getCountValue() * 2.0) {
                    placemark.setStyleUrl(this.yellowCrossStyle.getId());
                } else {
                    placemark.setStyleUrl(this.redCrossStyle.getId());
                }
            } else if (csc.getSimulationValue() > csc.getCountValue() * 0.75) {
                placemark.setStyleUrl("#greenMinusStyle");
            } else if (csc.getSimulationValue() > csc.getCountValue() * 0.5) {
                placemark.setStyleUrl("#yellowMinusStyle");
            } else {
                placemark.setStyleUrl("#redMinusStyle");
            }
            folder.getAbstractFeatureGroup().add(this.kmlObjectFactory.createPlacemark(placemark));
        }
    }

    private String createPlacemarkDescription(String stopid, CountSimComparison csc, double relativeError, int timestep, PtCountSimComparisonWriter.PtCountsType type) {
        StringBuilder buffer = new StringBuilder(100);
        buffer.append("<h2>");
        buffer.append(STOP);
        buffer.append(stopid).append("\t").append((Object)type).append("ing");
        buffer.append("</h2>");
        buffer.append("<h3>");
        buffer.append(H24OVERVIEW);
        buffer.append("</h3>");
        buffer.append("<p>");
        buffer.append(IMG);
        switch (type) {
            case Boarding: {
                buffer.append(this.boardCountsLoadCurveGraphMap.get(stopid + "b"));
                break;
            }
            case Alighting: {
                buffer.append(this.alightCountsLoadCurveGraphMap.get(stopid + "a"));
                break;
            }
            default: {
                buffer.append(this.occupancyCountsLoadCurveGraphMap.get(stopid + "o"));
            }
        }
        buffer.append(IMGEND);
        buffer.append("</p>");
        buffer.append("<h3>");
        buffer.append(DETAILSFROM);
        buffer.append(this.timestepToString(timestep - 1));
        buffer.append(OCLOCKTO);
        buffer.append(this.timestepToString(timestep));
        buffer.append(OCLOCK);
        buffer.append("</h3>");
        buffer.append("<p>");
        buffer.append(COUNTVALUE);
        buffer.append(csc.getCountValue());
        buffer.append("</p>");
        buffer.append("<p>");
        buffer.append(MATSIMVALUE);
        buffer.append(csc.getSimulationValue());
        buffer.append("</p>");
        buffer.append("<p>");
        buffer.append(RELERROR);
        buffer.append(relativeError);
        buffer.append("</p>");
        return buffer.toString();
    }

    private String timestepToString(int timestep) {
        if (timestep < 10) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(ZERO);
            buffer.append(Integer.toString(timestep));
            return buffer.toString();
        }
        return Integer.toString(timestep);
    }

    private String getSimRealGraphName(PtCountSimComparisonWriter.PtCountsType type, int timestep) {
        StringBuilder filename = new StringBuilder(type.toString());
        filename.append('-');
        filename.append(SIMREALGRAPHNAME);
        filename.append(timestep);
        filename.append(PNG);
        return filename.toString();
    }

    private void addCountsSimRealPerHourGraphs(FolderType folder, int timestep, TimeSpanType timespan) {
        try {
            String filenameBoard = this.getSimRealGraphName(PtCountSimComparisonWriter.PtCountsType.Boarding, timestep);
            String filenameAlight = this.getSimRealGraphName(PtCountSimComparisonWriter.PtCountsType.Alighting, timestep);
            String filenameOccupancy = this.getSimRealGraphName(PtCountSimComparisonWriter.PtCountsType.Occupancy, timestep);
            PtCountsSimRealPerHourGraph graphBoard = new PtCountsSimRealPerHourGraph(this.boardCountComparisonFilter.getCountsForHour(null), this.iter, filenameBoard, PtCountSimComparisonWriter.PtCountsType.Boarding);
            PtCountsSimRealPerHourGraph graphAlight = new PtCountsSimRealPerHourGraph(this.alightCountComparisonFilter.getCountsForHour(null), this.iter, filenameAlight, PtCountSimComparisonWriter.PtCountsType.Alighting);
            PtCountsSimRealPerHourGraph graphOccupancy = new PtCountsSimRealPerHourGraph(this.occupancyCountComparisonFilter.getCountsForHour(null), this.iter, filenameOccupancy, PtCountSimComparisonWriter.PtCountsType.Occupancy);
            graphBoard.createChart(timestep);
            this.writeChartToKmz(filenameBoard, graphBoard.getChart());
            this.addGraph2Screen(filenameBoard, graphBoard.getChartTitle(), timespan, folder, 1.0, 1.0, 0.98, 0.98);
            graphAlight.createChart(timestep);
            this.writeChartToKmz(filenameAlight, graphAlight.getChart());
            this.addGraph2Screen(filenameAlight, graphAlight.getChartTitle(), timespan, folder, 1.0, 0.75, 0.98, 0.73);
            graphOccupancy.createChart(timestep);
            this.writeChartToKmz(filenameOccupancy, graphOccupancy.getChart());
            this.addGraph2Screen(filenameOccupancy, graphOccupancy.getChartTitle(), timespan, folder, 1.0, 0.5, 0.98, 0.48);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void addGraph2Screen(String graphFilename, String chartTitle, TimeSpanType timespan, FolderType folder, double overlayX, double overlayY, double screenX, double screenY) {
        ScreenOverlayType overlay = this.kmlObjectFactory.createScreenOverlayType();
        LinkType icon = this.kmlObjectFactory.createLinkType();
        icon.setHref("./" + graphFilename);
        overlay.setIcon(icon);
        overlay.setName(chartTitle);
        Vec2Type overlayXY = this.kmlObjectFactory.createVec2Type();
        overlayXY.setX(overlayX);
        overlayXY.setY(overlayY);
        overlayXY.setXunits(UnitsEnumType.FRACTION);
        overlayXY.setYunits(UnitsEnumType.FRACTION);
        overlay.setOverlayXY(overlayXY);
        Vec2Type screenXY = this.kmlObjectFactory.createVec2Type();
        screenXY.setX(screenX);
        screenXY.setY(screenY);
        screenXY.setXunits(UnitsEnumType.FRACTION);
        screenXY.setYunits(UnitsEnumType.FRACTION);
        overlay.setScreenXY(screenXY);
        overlay.setAbstractTimePrimitiveGroup(this.kmlObjectFactory.createTimeSpan(timespan));
        folder.getAbstractFeatureGroup().add(this.kmlObjectFactory.createScreenOverlay(overlay));
    }

    private void createCountsLoadCurveGraphs(PtCountSimComparisonWriter.PtCountsType type, PtCountsLoadCurveGraphCreator cgc) {
        String postfix;
        List<CountsGraph> graphs;
        switch (type) {
            case Boarding: {
                graphs = cgc.createGraphs(this.boardCountComparisonFilter.getCountsForHour(null), this.iter);
                this.boardCountsLoadCurveGraphMap = new HashMap<String, String>(graphs.size());
                break;
            }
            case Alighting: {
                graphs = cgc.createGraphs(this.alightCountComparisonFilter.getCountsForHour(null), this.iter);
                this.alightCountsLoadCurveGraphMap = new HashMap<String, String>(graphs.size());
                break;
            }
            default: {
                graphs = cgc.createGraphs(this.occupancyCountComparisonFilter.getCountsForHour(null), this.iter);
                this.occupancyCountsLoadCurveGraphMap = new HashMap<String, String>(graphs.size());
            }
        }
        switch (type) {
            case Boarding: {
                postfix = "b";
                break;
            }
            case Alighting: {
                postfix = "a";
                break;
            }
            default: {
                postfix = "o";
            }
        }
        for (CountsGraph cg : graphs) {
            try {
                String stopId = ((CountsLoadCurveGraph)cg).getLinkId();
                String filename = stopId + postfix + PNG;
                this.writeChartToKmz(filename, cg.getChart());
                switch (type) {
                    case Boarding: {
                        this.boardCountsLoadCurveGraphMap.put(stopId + postfix, filename);
                        break;
                    }
                    case Alighting: {
                        this.alightCountsLoadCurveGraphMap.put(stopId + postfix, filename);
                        break;
                    }
                    default: {
                        this.occupancyCountsLoadCurveGraphMap.put(stopId + postfix, filename);
                        break;
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void createCountsLoadCurveGraphs() {
        PtCountsLoadCurveGraphCreator cgc = new PtCountsLoadCurveGraphCreator("");
        this.createCountsLoadCurveGraphs(PtCountSimComparisonWriter.PtCountsType.Boarding, cgc);
        this.createCountsLoadCurveGraphs(PtCountSimComparisonWriter.PtCountsType.Alighting, cgc);
        this.createCountsLoadCurveGraphs(PtCountSimComparisonWriter.PtCountsType.Occupancy, cgc);
    }

    private void writeChartToKmz(String filename, JFreeChart chart) throws IOException {
        byte[] img = ChartUtils.encodeAsPNG(chart.createBufferedImage(400, 300));
        this.writer.addNonKMLFile(img, filename);
    }

    private ScreenOverlayType createBiasErrorGraph(PtCountSimComparisonWriter.PtCountsType type, String kmlFilename) {
        List<CountSimComparison> countComparisonFilter;
        int index = kmlFilename.lastIndexOf(System.getProperty("file.separator"));
        if (index == -1) {
            index = kmlFilename.lastIndexOf(47);
        }
        String outdir = index == -1 ? "" : kmlFilename.substring(0, index) + System.getProperty("file.separator");
        switch (type) {
            case Boarding: {
                countComparisonFilter = this.boardCountComparisonFilter.getCountsForHour(null);
                break;
            }
            case Alighting: {
                countComparisonFilter = this.alightCountComparisonFilter.getCountsForHour(null);
                break;
            }
            default: {
                countComparisonFilter = this.occupancyCountComparisonFilter.getCountsForHour(null);
            }
        }
        PtBiasErrorGraph pbeg = new PtBiasErrorGraph(countComparisonFilter, this.iter, null, "error graph - " + type.name());
        pbeg.createChart(0);
        double[] meanError = pbeg.getMeanRelError();
        double[] meanBias = pbeg.getMeanAbsBias();
        String file = outdir + "biasErrorGraphData" + type.name() + ".txt";
        log.info("writing chart data to " + new File(file).getAbsolutePath());
        try {
            BufferedWriter bwriter = IOUtils.getBufferedWriter(file);
            StringBuilder buffer = new StringBuilder(100);
            buffer.append("hour \t mean relative error \t mean absolute bias");
            bwriter.write(buffer.toString());
            bwriter.newLine();
            for (int i = 0; i < meanError.length; ++i) {
                buffer.delete(0, buffer.length());
                buffer.append(i + 1);
                buffer.append('\t');
                buffer.append(meanError[i]);
                buffer.append('\t');
                buffer.append(meanBias[i]);
                bwriter.write(buffer.toString());
                bwriter.newLine();
            }
            bwriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String chartFilename = "errorGraphErrorBias" + type.name() + PNG;
        try {
            this.writeChartToKmz(chartFilename, pbeg.getChart());
            return this.createOverlayBottomRight(chartFilename, "Error Graph [Error/Bias]");
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private ScreenOverlayType createOverlayBottomRight(String fileName, String overlayName) {
        ScreenOverlayType overlay = this.kmlObjectFactory.createScreenOverlayType();
        LinkType icon1 = this.kmlObjectFactory.createLinkType();
        icon1.setHref("./" + fileName);
        overlay.setIcon(icon1);
        overlay.setName(overlayName);
        Vec2Type overlayXY = this.kmlObjectFactory.createVec2Type();
        overlayXY.setX(1.0);
        overlayXY.setY(0.0);
        overlayXY.setXunits(UnitsEnumType.FRACTION);
        overlayXY.setYunits(UnitsEnumType.FRACTION);
        overlay.setOverlayXY(overlayXY);
        Vec2Type screenXY = this.kmlObjectFactory.createVec2Type();
        screenXY.setX(0.98);
        screenXY.setY(0.1);
        screenXY.setXunits(UnitsEnumType.FRACTION);
        screenXY.setYunits(UnitsEnumType.FRACTION);
        overlay.setScreenXY(screenXY);
        return overlay;
    }

    private void finish() {
        this.writer.writeMainKml(this.mainKml);
        this.writer.close();
    }
}

