/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.pt.router;

import java.util.ArrayList;
import java.util.List;
import org.matsim.api.core.v01.Coord;
import org.matsim.api.core.v01.population.Leg;
import org.matsim.api.core.v01.population.Person;
import org.matsim.api.core.v01.population.Route;
import org.matsim.core.network.NetworkUtils;
import org.matsim.core.population.PopulationUtils;
import org.matsim.core.population.routes.RouteUtils;
import org.matsim.pt.router.RouteSegment;
import org.matsim.pt.router.TransitPassengerRoute;
import org.matsim.pt.router.TransitRouterConfig;
import org.matsim.pt.router.TransitTravelDisutility;
import org.matsim.pt.routes.ExperimentalTransitRoute;
import org.matsim.pt.transitSchedule.api.TransitStopFacility;

public class AbstractTransitRouter {
    private TransitRouterConfig trConfig;
    private TransitTravelDisutility travelDisutility;

    protected AbstractTransitRouter(TransitRouterConfig transitRouterConfig) {
        this.trConfig = transitRouterConfig;
    }

    protected AbstractTransitRouter(TransitRouterConfig config, TransitTravelDisutility transitTravelDisutility) {
        this.trConfig = config;
        this.travelDisutility = transitTravelDisutility;
    }

    protected void setTransitTravelDisutility(TransitTravelDisutility transitTravelDisutility) {
        this.travelDisutility = transitTravelDisutility;
    }

    protected final double getWalkTime(Person person, Coord coord, Coord toCoord) {
        return this.getTravelDisutility().getWalkTravelTime(person, coord, toCoord);
    }

    protected final double getTransferTime(Person person, Coord coord, Coord toCoord) {
        return this.getTravelDisutility().getWalkTravelTime(person, coord, toCoord) + this.getConfig().getAdditionalTransferTime();
    }

    protected final List<Leg> createDirectWalkLegList(Person person, Coord fromCoord, Coord toCoord) {
        ArrayList<Leg> legs = new ArrayList<Leg>();
        Leg leg = PopulationUtils.createLeg("transit_walk");
        double walkTime = this.getWalkTime(person, fromCoord, toCoord);
        leg.setTravelTime(walkTime);
        Route walkRoute = RouteUtils.createGenericRouteImpl(null, null);
        walkRoute.setTravelTime(walkTime);
        leg.setRoute(walkRoute);
        legs.add(leg);
        return legs;
    }

    private Leg createAccessTransitWalkLeg(Coord fromCoord, RouteSegment routeSegement) {
        Leg leg = this.createTransitWalkLeg(fromCoord, routeSegement.fromStop.getCoord());
        Route walkRoute = RouteUtils.createGenericRouteImpl(null, routeSegement.fromStop.getLinkId());
        walkRoute.setTravelTime(leg.getTravelTime());
        walkRoute.setDistance(this.trConfig.getBeelineDistanceFactor() * NetworkUtils.getEuclideanDistance(fromCoord, routeSegement.fromStop.getCoord()));
        leg.setRoute(walkRoute);
        return leg;
    }

    private Leg createEgressTransitWalkLeg(RouteSegment routeSegement, Coord toCoord) {
        Leg leg = this.createTransitWalkLeg(routeSegement.toStop.getCoord(), toCoord);
        Route walkRoute = RouteUtils.createGenericRouteImpl(routeSegement.toStop.getLinkId(), null);
        walkRoute.setTravelTime(leg.getTravelTime());
        walkRoute.setDistance(this.trConfig.getBeelineDistanceFactor() * NetworkUtils.getEuclideanDistance(routeSegement.toStop.getCoord(), toCoord));
        leg.setRoute(walkRoute);
        return leg;
    }

    private Leg createTransferTransitWalkLeg(RouteSegment routeSegement) {
        Leg leg = this.createTransitWalkLeg(routeSegement.getFromStop().getCoord(), routeSegement.getToStop().getCoord());
        Route walkRoute = RouteUtils.createGenericRouteImpl(routeSegement.getFromStop().getLinkId(), routeSegement.getToStop().getLinkId());
        leg.setTravelTime(this.getTransferTime(null, routeSegement.getFromStop().getCoord(), routeSegement.getToStop().getCoord()));
        walkRoute.setTravelTime(this.getTransferTime(null, routeSegement.getFromStop().getCoord(), routeSegement.getToStop().getCoord()));
        walkRoute.setDistance(this.trConfig.getBeelineDistanceFactor() * NetworkUtils.getEuclideanDistance(routeSegement.fromStop.getCoord(), routeSegement.toStop.getCoord()));
        leg.setRoute(walkRoute);
        return leg;
    }

    protected List<Leg> convertPassengerRouteToLegList(double departureTime, TransitPassengerRoute p, Coord fromCoord, Coord toCoord, Person person) {
        Leg egressLeg;
        Leg accessLeg;
        ArrayList<Leg> legs = new ArrayList<Leg>();
        if (p.getRoute().get(0).getRouteTaken() == null) {
            accessLeg = this.createAccessTransitWalkLeg(fromCoord, p.getRoute().get(0));
            p.getRoute().remove(0);
        } else {
            accessLeg = this.createAccessTransitWalkLeg(fromCoord, p.getRoute().get(0));
        }
        if (p.getRoute().get(p.getRoute().size() - 1).getRouteTaken() == null) {
            egressLeg = this.createEgressTransitWalkLeg(p.getRoute().get(p.getRoute().size() - 1), toCoord);
            p.getRoute().remove(p.getRoute().size() - 1);
        } else {
            egressLeg = this.createEgressTransitWalkLeg(p.getRoute().get(p.getRoute().size() - 1), toCoord);
        }
        legs.add(accessLeg);
        for (RouteSegment routeSegement : p.getRoute()) {
            if (routeSegement.getRouteTaken() == null) {
                if (routeSegement.fromStop.equals(routeSegement.toStop)) continue;
                legs.add(this.createTransferTransitWalkLeg(routeSegement));
                continue;
            }
            legs.add(this.createTransitLeg(routeSegement));
        }
        legs.add(egressLeg);
        return legs;
    }

    private Leg createTransitLeg(RouteSegment routeSegment) {
        Leg leg = PopulationUtils.createLeg("pt");
        TransitStopFacility accessStop = routeSegment.getFromStop();
        TransitStopFacility egressStop = routeSegment.getToStop();
        ExperimentalTransitRoute ptRoute = new ExperimentalTransitRoute(accessStop, egressStop, routeSegment.getLineTaken(), routeSegment.getRouteTaken());
        ptRoute.setTravelTime(routeSegment.travelTime);
        leg.setRoute(ptRoute);
        leg.setTravelTime(routeSegment.getTravelTime());
        return leg;
    }

    private Leg createTransitWalkLeg(Coord fromCoord, Coord toCoord) {
        Leg leg = PopulationUtils.createLeg("transit_walk");
        double walkTime = this.getWalkTime(null, fromCoord, toCoord);
        leg.setTravelTime(walkTime);
        return leg;
    }

    protected final TransitRouterConfig getConfig() {
        return this.trConfig;
    }

    protected final double getWalkDisutility(Person person, Coord coord, Coord toCoord) {
        return this.getTravelDisutility().getWalkTravelDisutility(person, coord, toCoord);
    }

    protected final TransitTravelDisutility getTravelDisutility() {
        return this.travelDisutility;
    }
}

