/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.pt.router;

import java.util.HashMap;
import java.util.Map;
import org.matsim.api.core.v01.network.Network;
import org.matsim.api.core.v01.network.Node;
import org.matsim.api.core.v01.population.Person;
import org.matsim.core.router.InitialNode;
import org.matsim.core.router.util.LeastCostPathCalculator;
import org.matsim.core.router.util.TravelTime;
import org.matsim.pt.router.TransitLeastCostPathTree;
import org.matsim.pt.router.TransitTravelDisutility;

public class MultiNodeDijkstra {
    protected Network network;
    private final TransitTravelDisutility costFunction;
    private final TravelTime timeFunction;

    public MultiNodeDijkstra(Network network, TransitTravelDisutility costFunction, TravelTime timeFunction) {
        this.network = network;
        this.costFunction = costFunction;
        this.timeFunction = timeFunction;
    }

    public LeastCostPathCalculator.Path calcLeastCostPath(Map<Node, InitialNode> fromNodes, Map<Node, InitialNode> toNodes, Person person) {
        Map<Node, InitialNode> swapedToNodes = this.swapNodes(toNodes);
        TransitLeastCostPathTree tree = new TransitLeastCostPathTree(this.network, this.costFunction, this.timeFunction, this.swapNodes(fromNodes), swapedToNodes, person);
        return tree.getPath(swapedToNodes);
    }

    private Map<Node, InitialNode> swapNodes(Map<Node, InitialNode> original) {
        HashMap<Node, InitialNode> result = new HashMap<Node, InitialNode>();
        for (Map.Entry<Node, InitialNode> entry : original.entrySet()) {
            result.put(entry.getKey(), new InitialNode(entry.getValue().initialCost, entry.getValue().initialTime));
        }
        return result;
    }
}

