/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.pt.router;

import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.matsim.pt.transitSchedule.api.Departure;
import org.matsim.pt.transitSchedule.api.TransitRoute;
import org.matsim.pt.transitSchedule.api.TransitRouteStop;
import org.matsim.pt.transitSchedule.api.TransitSchedule;

public class PreparedTransitSchedule {
    private final Map<TransitRoute, double[]> sortedDepartureCache = new ConcurrentHashMap<TransitRoute, double[]>();

    public PreparedTransitSchedule(TransitSchedule schedule) {
    }

    @Deprecated
    public PreparedTransitSchedule() {
    }

    public double getNextDepartureTime(TransitRoute route, TransitRouteStop stop, double depTime) {
        int pos;
        double[] cache;
        double earliestDepartureTimeAtTerminus = depTime - stop.getDepartureOffset();
        if (earliestDepartureTimeAtTerminus >= 86400.0) {
            earliestDepartureTimeAtTerminus %= 86400.0;
        }
        if (earliestDepartureTimeAtTerminus < 0.0) {
            earliestDepartureTimeAtTerminus += 86400.0;
        }
        if ((cache = this.sortedDepartureCache.get(route)) == null) {
            cache = new double[route.getDepartures().size()];
            int i = 0;
            for (Departure dep : route.getDepartures().values()) {
                cache[i++] = dep.getDepartureTime();
            }
            Arrays.sort(cache);
            this.sortedDepartureCache.put(route, cache);
        }
        if ((pos = Arrays.binarySearch(cache, earliestDepartureTimeAtTerminus)) < 0) {
            pos = -(pos + 1);
        }
        if (pos >= cache.length) {
            pos = 0;
        }
        double bestDepartureTime = cache[pos];
        bestDepartureTime += stop.getDepartureOffset();
        while (bestDepartureTime < depTime) {
            bestDepartureTime += 86400.0;
        }
        return bestDepartureTime;
    }
}

