/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.pt.router;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Network;
import org.matsim.api.core.v01.network.Node;
import org.matsim.api.core.v01.population.Person;
import org.matsim.core.router.InitialNode;
import org.matsim.core.router.util.DijkstraNodeData;
import org.matsim.core.router.util.LeastCostPathCalculator;
import org.matsim.core.router.util.TravelTime;
import org.matsim.core.utils.collections.PseudoRemovePriorityQueue;
import org.matsim.core.utils.collections.RouterPriorityQueue;
import org.matsim.pt.router.CustomDataManager;
import org.matsim.pt.router.RouteSegment;
import org.matsim.pt.router.TransitPassengerRoute;
import org.matsim.pt.router.TransitRouterNetwork;
import org.matsim.pt.router.TransitRouterNetworkTravelTimeAndDisutility;
import org.matsim.pt.router.TransitTravelDisutility;
import org.matsim.pt.transitSchedule.api.TransitLine;
import org.matsim.pt.transitSchedule.api.TransitRoute;
import org.matsim.pt.transitSchedule.api.TransitStopFacility;
import org.matsim.vehicles.Vehicle;

public class TransitLeastCostPathTree {
    protected Network network;
    private final TransitTravelDisutility costFunction;
    private final TravelTime timeFunction;
    private final HashMap<Id<Node>, DijkstraNodeData> nodeData;
    private Person person = null;
    private Vehicle vehicle = null;
    private CustomDataManager customDataManager = new CustomDataManager();
    private Map<Node, InitialNode> fromNodes = null;
    private RouterPriorityQueue<Node> pendingNodes;

    public TransitLeastCostPathTree(Network network, TransitTravelDisutility costFunction, TravelTime timeFunction, Map<Node, InitialNode> fromNodes, Person person) {
        this.network = network;
        this.costFunction = costFunction;
        this.timeFunction = timeFunction;
        this.nodeData = new HashMap((int)((double)network.getNodes().size() * 1.1), 0.95f);
        this.resetNetworkVisited();
        this.person = person;
        this.customDataManager.reset();
        this.fromNodes = fromNodes;
        this.pendingNodes = this.createRouterPriorityQueue();
        for (Map.Entry<Node, InitialNode> entry : fromNodes.entrySet()) {
            DijkstraNodeData data = this.getData(entry.getKey());
            this.visitNode(entry.getKey(), data, this.pendingNodes, entry.getValue().initialTime, entry.getValue().initialCost, null);
        }
        while (this.pendingNodes.size() > 0) {
            Node outNode = this.pendingNodes.poll();
            this.relaxNode(outNode, this.pendingNodes);
        }
    }

    public TransitLeastCostPathTree(Network network, TransitTravelDisutility costFunction, TravelTime timeFunction, Map<Node, InitialNode> fromNodes, Map<Node, InitialNode> toNodes, Person person) {
        this.network = network;
        this.costFunction = costFunction;
        this.timeFunction = timeFunction;
        this.nodeData = new HashMap((int)((double)network.getNodes().size() * 1.1), 0.95f);
        this.resetNetworkVisited();
        this.person = person;
        this.customDataManager.reset();
        this.fromNodes = fromNodes;
        this.pendingNodes = this.createRouterPriorityQueue();
        for (Map.Entry<Node, InitialNode> entry : fromNodes.entrySet()) {
            DijkstraNodeData data = this.getData(entry.getKey());
            this.visitNode(entry.getKey(), data, this.pendingNodes, entry.getValue().initialTime, entry.getValue().initialCost, null);
        }
        this.expandNodeData(toNodes);
    }

    private int getIterationId() {
        return 0;
    }

    private void resetNetworkVisited() {
        for (Node node : this.network.getNodes().values()) {
            DijkstraNodeData data = this.getData(node);
            data.resetVisited();
        }
    }

    private void expandNodeData(Map<Node, InitialNode> toNodes) {
        HashSet<Node> endNodes = new HashSet<Node>(toNodes.keySet());
        double minCost = Double.POSITIVE_INFINITY;
        while (endNodes.size() > 0) {
            Node outNode = this.pendingNodes.poll();
            if (outNode == null) {
                endNodes.clear();
                continue;
            }
            DijkstraNodeData data = this.getData(outNode);
            boolean isEndNode = endNodes.remove(outNode);
            if (isEndNode) {
                InitialNode initData = toNodes.get(outNode);
                double cost = data.getCost() + initData.initialCost;
                if (cost < minCost) {
                    minCost = cost;
                }
            }
            if (data.getCost() > minCost) {
                endNodes.clear();
                continue;
            }
            this.relaxNode(outNode, this.pendingNodes);
        }
    }

    public TransitPassengerRoute getTransitPassengerRoute(Map<Node, InitialNode> toNodes) {
        double minCost = Double.POSITIVE_INFINITY;
        Node minCostNode = null;
        for (Map.Entry<Node, InitialNode> e : toNodes.entrySet()) {
            Node currentNode = e.getKey();
            DijkstraNodeData r = this.nodeData.get(currentNode.getId());
            if (r == null) {
                this.expandNodeData(toNodes);
            }
            DijkstraNodeData data = this.getData(currentNode);
            InitialNode initData = e.getValue();
            double cost = data.getCost() + initData.initialCost;
            if (data.getCost() == 0.0 && !this.fromNodes.containsKey(currentNode) || !(cost < minCost)) continue;
            minCost = cost;
            minCostNode = currentNode;
        }
        if (minCostNode == null) {
            return null;
        }
        ArrayList<RouteSegment> routeSegments = new ArrayList<RouteSegment>();
        TransitRouterNetwork.TransitRouterNetworkLink link = (TransitRouterNetwork.TransitRouterNetworkLink)this.getData(minCostNode).getPrevLink();
        TransitRouterNetwork.TransitRouterNetworkLink downstreamLink = null;
        Node previousFromNode = minCostNode;
        double transferCost = 0.0;
        while (link != null) {
            TransitRouterNetwork.TransitRouterNetworkNode fromNode = link.fromNode;
            TransitRouterNetwork.TransitRouterNetworkNode toNode = link.toNode;
            double travelTime = this.getData(toNode).getTime() - this.getData(fromNode).getTime();
            Id<TransitLine> transitLineId = null;
            Id<TransitRoute> routeId = null;
            boolean isTransferLeg = false;
            if (link.line == null) {
                isTransferLeg = true;
            } else {
                transitLineId = link.line.getId();
                routeId = link.route.getId();
            }
            if (downstreamLink == null && isTransferLeg) {
                double tempTravelTime = 0.0;
                TransitStopFacility toStop = null;
                if (routeSegments.size() == 0) {
                    toStop = toNode.stop.getStopFacility();
                } else {
                    RouteSegment routeSegment = (RouteSegment)routeSegments.remove(0);
                    travelTime = routeSegment.travelTime;
                    toStop = routeSegment.toStop;
                }
                routeSegments.add(0, new RouteSegment(fromNode.stop.getStopFacility(), toStop, tempTravelTime + travelTime, transitLineId, routeId));
            } else if (downstreamLink == null || isTransferLeg) {
                routeSegments.add(0, new RouteSegment(fromNode.stop.getStopFacility(), toNode.stop.getStopFacility(), travelTime, transitLineId, routeId));
            } else if (downstreamLink.line.getId() == link.line.getId() && downstreamLink.route.getId() == link.route.getId()) {
                RouteSegment routeSegment = (RouteSegment)routeSegments.remove(0);
                routeSegments.add(0, new RouteSegment(fromNode.stop.getStopFacility(), routeSegment.toStop, routeSegment.travelTime + travelTime, transitLineId, routeId));
            }
            if (isTransferLeg) {
                if (!(this.costFunction instanceof TransitRouterNetworkTravelTimeAndDisutility)) {
                    throw new RuntimeException("TransitTravelDisutility is not instance of " + TransitRouterNetworkTravelTimeAndDisutility.class.getSimpleName() + ". An acc ");
                }
                transferCost += ((TransitRouterNetworkTravelTimeAndDisutility)this.costFunction).defaultTransferCost(link, Double.NEGATIVE_INFINITY, null, null);
                downstreamLink = null;
            } else {
                downstreamLink = link;
            }
            previousFromNode = fromNode;
            link = (TransitRouterNetwork.TransitRouterNetworkLink)this.getData(fromNode).getPrevLink();
        }
        DijkstraNodeData startNodeData = this.getData(previousFromNode);
        DijkstraNodeData toNodeData = this.getData(minCostNode);
        double cost = toNodeData.getCost() - startNodeData.getCost() + this.fromNodes.get(previousFromNode).initialCost + toNodes.get(minCostNode).initialCost + transferCost;
        if (routeSegments.size() == 0) {
            return null;
        }
        return new TransitPassengerRoute(cost, routeSegments);
    }

    public LeastCostPathCalculator.Path getPath(Map<Node, InitialNode> toNodes) {
        double minCost = Double.POSITIVE_INFINITY;
        Node minCostNode = null;
        for (Map.Entry<Node, InitialNode> e : toNodes.entrySet()) {
            Node currentNode = e.getKey();
            DijkstraNodeData r = this.nodeData.get(currentNode.getId());
            if (r == null) {
                this.expandNodeData(toNodes);
            }
            DijkstraNodeData data = this.getData(currentNode);
            InitialNode initData = e.getValue();
            double cost = data.getCost() + initData.initialCost;
            if (data.getCost() == 0.0 && !this.fromNodes.containsKey(currentNode) || !(cost < minCost)) continue;
            minCost = cost;
            minCostNode = currentNode;
        }
        if (minCostNode == null) {
            return null;
        }
        LinkedList<Node> nodes = new LinkedList<Node>();
        LinkedList<Link> links = new LinkedList<Link>();
        nodes.add(0, minCostNode);
        Link tmpLink = this.getData(minCostNode).getPrevLink();
        while (tmpLink != null) {
            links.add(0, tmpLink);
            nodes.add(0, tmpLink.getFromNode());
            tmpLink = this.getData(tmpLink.getFromNode()).getPrevLink();
        }
        DijkstraNodeData startNodeData = this.getData((Node)nodes.get(0));
        DijkstraNodeData toNodeData = this.getData(minCostNode);
        return new LeastCostPathCalculator.Path(nodes, links, toNodeData.getTime() - startNodeData.getTime(), toNodeData.getCost() - startNodeData.getCost());
    }

    RouterPriorityQueue<? extends Node> createRouterPriorityQueue() {
        return new PseudoRemovePriorityQueue(500);
    }

    protected void visitNode(Node n, DijkstraNodeData data, RouterPriorityQueue<Node> pendingNodes, double time, double cost, Link outLink) {
        data.visit(outLink, cost, time, this.getIterationId());
        pendingNodes.add(n, this.getPriority(data));
    }

    protected void relaxNode(Node outNode, RouterPriorityQueue<Node> pendingNodes) {
        DijkstraNodeData outData = this.getData(outNode);
        double currTime = outData.getTime();
        double currCost = outData.getCost();
        for (Link link : outNode.getOutLinks().values()) {
            this.relaxNodeLogic(link, pendingNodes, currTime, currCost);
        }
    }

    void relaxNodeLogic(Link l, RouterPriorityQueue<Node> pendingNodes, double currTime, double currCost) {
        this.addToPendingNodes(l, l.getToNode(), pendingNodes, currTime, currCost);
    }

    protected boolean addToPendingNodes(Link l, Node n, RouterPriorityQueue<Node> pendingNodes, double currTime, double currCost) {
        this.customDataManager.initForLink(l);
        double travelTime = this.timeFunction.getLinkTravelTime(l, currTime, this.person, this.vehicle);
        double travelCost = this.costFunction.getLinkTravelDisutility(l, currTime, this.person, this.vehicle, this.customDataManager);
        DijkstraNodeData data = this.getData(n);
        double nCost = data.getCost();
        if (!data.isVisited(this.getIterationId())) {
            this.visitNode(n, data, pendingNodes, currTime + travelTime, currCost + travelCost, l);
            this.customDataManager.storeTmpData();
            return true;
        }
        double totalCost = currCost + travelCost;
        if (totalCost < nCost) {
            this.revisitNode(n, data, pendingNodes, currTime + travelTime, totalCost, l);
            this.customDataManager.storeTmpData();
            return true;
        }
        return false;
    }

    void revisitNode(Node n, DijkstraNodeData data, RouterPriorityQueue<Node> pendingNodes, double time, double cost, Link outLink) {
        pendingNodes.remove(n);
        data.visit(outLink, cost, time, this.getIterationId());
        pendingNodes.add(n, this.getPriority(data));
    }

    private double getPriority(DijkstraNodeData data) {
        return data.getCost();
    }

    protected DijkstraNodeData getData(Node n) {
        DijkstraNodeData r = this.nodeData.get(n.getId());
        if (null == r) {
            r = new DijkstraNodeData();
            this.nodeData.put(n.getId(), r);
        }
        return r;
    }
}

