/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.pt.router;

import java.util.Map;
import org.apache.log4j.Logger;
import org.matsim.core.api.internal.MatsimParameters;
import org.matsim.core.config.Config;
import org.matsim.core.config.groups.PlanCalcScoreConfigGroup;
import org.matsim.core.config.groups.PlansCalcRouteConfigGroup;
import org.matsim.core.config.groups.VspExperimentalConfigGroup;
import org.matsim.core.gbl.Gbl;
import org.matsim.pt.config.TransitRouterConfigGroup;

public class TransitRouterConfig
implements MatsimParameters {
    private double searchRadius = 1000.0;
    private double extensionRadius = 200.0;
    private double beelineWalkConnectionDistance = 100.0;
    private double additionalTransferTime = 0.0;
    private double beelineWalkSpeed;
    private double marginalUtilityOfTravelTimeWalk_utl_s;
    private double marginalUtilityOfTravelTimeTransit_utl_s;
    private double marginalUtilityOfWaitingPt_utl_s;
    private double marginalUtilityOfTravelDistanceWalk_utl_m;
    private double marginalUtilityOfTravelDistanceTransit_utl_m;
    private double utilityOfLineSwitch_utl;
    private Double beelineDistanceFactor;
    private final double directWalkFactor;
    private boolean cacheTree;

    public TransitRouterConfig(Config config) {
        this(config.planCalcScore(), config.plansCalcRoute(), config.transitRouter(), config.vspExperimental());
    }

    public TransitRouterConfig(PlanCalcScoreConfigGroup pcsConfig, PlansCalcRouteConfigGroup pcrConfig, TransitRouterConfigGroup trConfig, VspExperimentalConfigGroup vspConfig) {
        pcsConfig.setLocked();
        pcrConfig.setLocked();
        trConfig.setLocked();
        vspConfig.setLocked();
        if (pcsConfig.getScoringParametersPerSubpopulation().size() > 1) {
            Logger.getLogger(this.getClass()).warn("More than one subpopulation is used in plansCalcScore. This is not currently implemented in the TransitRouter (but should work for scoring), so the values for the \"default\" subpopulation will be used. (jb, Feb 2018)");
        }
        for (Map.Entry<String, PlansCalcRouteConfigGroup.ModeRoutingParams> entry : pcrConfig.getModeRoutingParams().entrySet()) {
            Logger.getLogger(this.getClass()).warn("mode=" + entry.getKey() + "; params=" + entry.getValue());
        }
        PlansCalcRouteConfigGroup.ModeRoutingParams params = pcrConfig.getModeRoutingParams().get("non_network_walk");
        Gbl.assertNotNull(params);
        this.beelineDistanceFactor = params.getBeelineDistanceFactor();
        this.beelineWalkSpeed = pcrConfig.getTeleportedModeSpeeds().get("non_network_walk") / this.beelineDistanceFactor;
        this.marginalUtilityOfTravelTimeWalk_utl_s = pcsConfig.getModes().get("walk").getMarginalUtilityOfTraveling() / 3600.0 - pcsConfig.getPerforming_utils_hr() / 3600.0;
        this.marginalUtilityOfTravelDistanceWalk_utl_m = pcsConfig.getMarginalUtilityOfMoney() * pcsConfig.getModes().get("walk").getMonetaryDistanceRate() + pcsConfig.getModes().get("walk").getMarginalUtilityOfDistance();
        this.marginalUtilityOfTravelTimeTransit_utl_s = pcsConfig.getModes().get("pt").getMarginalUtilityOfTraveling() / 3600.0 - pcsConfig.getPerforming_utils_hr() / 3600.0;
        this.marginalUtilityOfTravelDistanceTransit_utl_m = pcsConfig.getMarginalUtilityOfMoney() * pcsConfig.getModes().get("pt").getMonetaryDistanceRate() + pcsConfig.getModes().get("pt").getMarginalUtilityOfDistance();
        this.marginalUtilityOfWaitingPt_utl_s = pcsConfig.getMarginalUtlOfWaitingPt_utils_hr() / 3600.0 - pcsConfig.getPerforming_utils_hr() / 3600.0;
        this.utilityOfLineSwitch_utl = pcsConfig.getUtilityOfLineSwitch();
        this.setSearchRadius(trConfig.getSearchRadius());
        this.setExtensionRadius(trConfig.getExtensionRadius());
        this.setBeelineWalkConnectionDistance(trConfig.getMaxBeelineWalkConnectionDistance());
        this.setAdditionalTransferTime(trConfig.getAdditionalTransferTime());
        this.directWalkFactor = trConfig.getDirectWalkFactor();
        this.cacheTree = trConfig.isCacheTree();
    }

    public void setUtilityOfLineSwitch_utl(double utilityOfLineSwitch_utl_sec) {
        this.utilityOfLineSwitch_utl = utilityOfLineSwitch_utl_sec;
    }

    public double getUtilityOfLineSwitch_utl() {
        return this.utilityOfLineSwitch_utl;
    }

    public void setMarginalUtilityOfTravelTimeWalk_utl_s(double marginalUtilityOfTravelTimeWalk_utl_s) {
        this.marginalUtilityOfTravelTimeWalk_utl_s = marginalUtilityOfTravelTimeWalk_utl_s;
    }

    public double getMarginalUtilityOfTravelTimeWalk_utl_s() {
        return this.marginalUtilityOfTravelTimeWalk_utl_s;
    }

    public void setMarginalUtilityOfTravelTimePt_utl_s(double marginalUtilityOfTravelTimeTransit_utl_s) {
        this.marginalUtilityOfTravelTimeTransit_utl_s = marginalUtilityOfTravelTimeTransit_utl_s;
    }

    public void setMarginalUtilityOfTravelDistanceWalk_utl_m(double marginalUtilityOfTravelDistanceWalk_utl_m) {
        this.marginalUtilityOfTravelDistanceWalk_utl_m = marginalUtilityOfTravelDistanceWalk_utl_m;
    }

    public double getMarginalUtilityOfTravelTimePt_utl_s() {
        return this.marginalUtilityOfTravelTimeTransit_utl_s;
    }

    public void setMarginalUtilityOfTravelDistancePt_utl_m(double marginalUtilityOfTravelDistanceTransit_utl_m) {
        this.marginalUtilityOfTravelDistanceTransit_utl_m = marginalUtilityOfTravelDistanceTransit_utl_m;
    }

    public double getMarginalUtilityOfWaitingPt_utl_s() {
        return this.marginalUtilityOfWaitingPt_utl_s;
    }

    public void setMarginalUtilityOfWaitingPt_utl_s(double effectiveMarginalUtilityOfWaiting_utl_s) {
        this.marginalUtilityOfWaitingPt_utl_s = effectiveMarginalUtilityOfWaiting_utl_s;
    }

    public double getMarginalUtilityOfTravelDistancePt_utl_m() {
        return this.marginalUtilityOfTravelDistanceTransit_utl_m;
    }

    public double getMarginalUtilityOfTravelDistanceWalk_utl_m() {
        return this.marginalUtilityOfTravelDistanceWalk_utl_m;
    }

    public void setBeelineWalkSpeed(double beelineWalkSpeed) {
        this.beelineWalkSpeed = beelineWalkSpeed;
    }

    public double getBeelineWalkSpeed() {
        return this.beelineWalkSpeed;
    }

    public double getSearchRadius() {
        return this.searchRadius;
    }

    public void setSearchRadius(double searchRadius) {
        this.searchRadius = searchRadius;
    }

    public double getExtensionRadius() {
        return this.extensionRadius;
    }

    public void setExtensionRadius(double extensionRadius) {
        this.extensionRadius = extensionRadius;
    }

    public double getBeelineWalkConnectionDistance() {
        return this.beelineWalkConnectionDistance;
    }

    public void setBeelineWalkConnectionDistance(double beelineWalkConnectionDistance) {
        this.beelineWalkConnectionDistance = beelineWalkConnectionDistance;
    }

    public double getAdditionalTransferTime() {
        return this.additionalTransferTime;
    }

    public void setAdditionalTransferTime(double additionalTransferTime) {
        this.additionalTransferTime = additionalTransferTime;
    }

    public final Double getBeelineDistanceFactor() {
        return this.beelineDistanceFactor;
    }

    public double getDirectWalkFactor() {
        return this.directWalkFactor;
    }

    public boolean isCacheTree() {
        return this.cacheTree;
    }

    public void setCacheTree(boolean cacheTree) {
        this.cacheTree = cacheTree;
    }
}

