/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.pt.router;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.matsim.api.core.v01.Coord;
import org.matsim.api.core.v01.network.Node;
import org.matsim.api.core.v01.population.Leg;
import org.matsim.api.core.v01.population.Person;
import org.matsim.core.router.InitialNode;
import org.matsim.core.router.util.TravelTime;
import org.matsim.core.utils.geometry.CoordUtils;
import org.matsim.facilities.Facility;
import org.matsim.pt.router.AbstractTransitRouter;
import org.matsim.pt.router.PreparedTransitSchedule;
import org.matsim.pt.router.TransitLeastCostPathTree;
import org.matsim.pt.router.TransitPassengerRoute;
import org.matsim.pt.router.TransitRouter;
import org.matsim.pt.router.TransitRouterConfig;
import org.matsim.pt.router.TransitRouterNetwork;
import org.matsim.pt.router.TransitRouterNetworkTravelTimeAndDisutility;
import org.matsim.pt.router.TransitTravelDisutility;
import org.matsim.pt.transitSchedule.api.TransitSchedule;

public class TransitRouterImpl
extends AbstractTransitRouter
implements TransitRouter {
    private final TransitRouterNetwork transitNetwork;
    private final TravelTime travelTime;
    private final TransitTravelDisutility travelDisutility;
    private final PreparedTransitSchedule preparedTransitSchedule;
    private boolean cacheTree;
    private TransitLeastCostPathTree tree;
    private Facility previousFromFacility;
    private double previousDepartureTime;

    public TransitRouterImpl(TransitRouterConfig trConfig, TransitSchedule schedule) {
        super(trConfig);
        this.transitNetwork = TransitRouterNetwork.createFromSchedule(schedule, trConfig.getBeelineWalkConnectionDistance());
        this.preparedTransitSchedule = new PreparedTransitSchedule(schedule);
        TransitRouterNetworkTravelTimeAndDisutility transitRouterNetworkTravelTimeAndDisutility = new TransitRouterNetworkTravelTimeAndDisutility(trConfig, new PreparedTransitSchedule(schedule));
        this.travelDisutility = transitRouterNetworkTravelTimeAndDisutility;
        this.travelTime = transitRouterNetworkTravelTimeAndDisutility;
        this.setTransitTravelDisutility(this.travelDisutility);
        this.cacheTree = trConfig.isCacheTree();
    }

    public TransitRouterImpl(TransitRouterConfig trConfig, PreparedTransitSchedule preparedTransitSchedule, TransitRouterNetwork routerNetwork, TravelTime travelTime, TransitTravelDisutility travelDisutility) {
        super(trConfig, travelDisutility);
        this.transitNetwork = routerNetwork;
        this.preparedTransitSchedule = preparedTransitSchedule;
        this.travelDisutility = travelDisutility;
        this.travelTime = travelTime;
        this.cacheTree = trConfig.isCacheTree();
    }

    private Map<Node, InitialNode> locateWrappedNearestTransitNodes(Person person, Coord coord, double departureTime) {
        TransitRouterNetwork.TransitRouterNetworkNode nearestNode;
        Collection<TransitRouterNetwork.TransitRouterNetworkNode> nearestNodes = this.getTransitRouterNetwork().getNearestNodes(coord, this.getConfig().getSearchRadius());
        if (nearestNodes.size() < 2 && (nearestNode = this.getTransitRouterNetwork().getNearestNode(coord)) != null) {
            double distance = CoordUtils.calcEuclideanDistance(coord, nearestNode.stop.getStopFacility().getCoord());
            nearestNodes = this.getTransitRouterNetwork().getNearestNodes(coord, distance + this.getConfig().getExtensionRadius());
        }
        LinkedHashMap<Node, InitialNode> wrappedNearestNodes = new LinkedHashMap<Node, InitialNode>();
        for (TransitRouterNetwork.TransitRouterNetworkNode node : nearestNodes) {
            Coord toCoord = node.stop.getStopFacility().getCoord();
            double initialTime = this.getWalkTime(person, coord, toCoord);
            double initialCost = this.getWalkDisutility(person, coord, toCoord);
            wrappedNearestNodes.put(node, new InitialNode(initialCost, initialTime + departureTime));
        }
        return wrappedNearestNodes;
    }

    @Override
    public List<Leg> calcRoute(Facility fromFacility, Facility toFacility, double departureTime, Person person) {
        Map<Node, InitialNode> wrappedFromNodes = this.locateWrappedNearestTransitNodes(person, fromFacility.getCoord(), departureTime);
        Map<Node, InitialNode> wrappedToNodes = this.locateWrappedNearestTransitNodes(person, toFacility.getCoord(), departureTime);
        TransitPassengerRoute transitPassengerRoute = null;
        if (this.cacheTree) {
            if (fromFacility != this.previousFromFacility && departureTime != this.previousDepartureTime) {
                this.tree = new TransitLeastCostPathTree(this.getTransitRouterNetwork(), this.getTravelDisutility(), this.getTravelTime(), wrappedFromNodes, person);
            }
        } else {
            this.tree = new TransitLeastCostPathTree(this.getTransitRouterNetwork(), this.getTravelDisutility(), this.getTravelTime(), wrappedFromNodes, wrappedToNodes, person);
        }
        if ((transitPassengerRoute = this.tree.getTransitPassengerRoute(wrappedToNodes)) == null) {
            return this.createDirectWalkLegList(null, fromFacility.getCoord(), toFacility.getCoord());
        }
        double pathCost = transitPassengerRoute.getTravelCost();
        double directWalkCost = this.getWalkDisutility(person, fromFacility.getCoord(), toFacility.getCoord());
        if (directWalkCost * this.getConfig().getDirectWalkFactor() < pathCost) {
            return this.createDirectWalkLegList(null, fromFacility.getCoord(), toFacility.getCoord());
        }
        this.previousFromFacility = fromFacility;
        this.previousDepartureTime = departureTime;
        return this.convertPassengerRouteToLegList(departureTime, transitPassengerRoute, fromFacility.getCoord(), toFacility.getCoord(), person);
    }

    public TransitRouterNetwork getTransitRouterNetwork() {
        return this.transitNetwork;
    }

    TravelTime getTravelTime() {
        return this.travelTime;
    }

    PreparedTransitSchedule getPreparedTransitSchedule() {
        return this.preparedTransitSchedule;
    }
}

