/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.pt.router;

import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.matsim.core.api.experimental.events.EventsManager;
import org.matsim.core.config.Config;
import org.matsim.pt.router.PreparedTransitSchedule;
import org.matsim.pt.router.TransitRouter;
import org.matsim.pt.router.TransitRouterConfig;
import org.matsim.pt.router.TransitRouterImpl;
import org.matsim.pt.router.TransitRouterNetwork;
import org.matsim.pt.router.TransitRouterNetworkTravelTimeAndDisutility;
import org.matsim.pt.transitSchedule.api.TransitSchedule;

@Singleton
public class TransitRouterImplFactory
implements Provider<TransitRouter> {
    private final TransitRouterConfig config;
    private final TransitSchedule transitSchedule;
    private TransitRouterNetwork routerNetwork;
    private PreparedTransitSchedule preparedTransitSchedule;

    @Inject
    TransitRouterImplFactory(TransitSchedule schedule, EventsManager events, Config config) {
        this(schedule, new TransitRouterConfig(config.planCalcScore(), config.plansCalcRoute(), config.transitRouter(), config.vspExperimental()));
        events.addHandler(event -> {
            this.routerNetwork = null;
            this.preparedTransitSchedule = null;
        });
    }

    public TransitRouterImplFactory(TransitSchedule schedule, TransitRouterConfig config) {
        this.config = config;
        this.transitSchedule = schedule;
    }

    @Override
    public TransitRouter get() {
        if (this.routerNetwork == null) {
            this.routerNetwork = TransitRouterNetwork.createFromSchedule(this.transitSchedule, this.config.getBeelineWalkConnectionDistance());
        }
        if (this.preparedTransitSchedule == null) {
            this.preparedTransitSchedule = new PreparedTransitSchedule(this.transitSchedule);
        }
        TransitRouterNetworkTravelTimeAndDisutility ttCalculator = new TransitRouterNetworkTravelTimeAndDisutility(this.config, this.preparedTransitSchedule);
        return new TransitRouterImpl(this.config, this.preparedTransitSchedule, this.routerNetwork, ttCalculator, ttCalculator);
    }
}

