/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.pt.router;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Coord;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Network;
import org.matsim.api.core.v01.network.NetworkFactory;
import org.matsim.api.core.v01.network.Node;
import org.matsim.core.utils.collections.IdentifiableArrayMap;
import org.matsim.core.utils.collections.QuadTree;
import org.matsim.core.utils.collections.Tuple;
import org.matsim.core.utils.geometry.CoordUtils;
import org.matsim.core.utils.misc.Counter;
import org.matsim.pt.transitSchedule.api.TransitLine;
import org.matsim.pt.transitSchedule.api.TransitRoute;
import org.matsim.pt.transitSchedule.api.TransitRouteStop;
import org.matsim.pt.transitSchedule.api.TransitSchedule;
import org.matsim.utils.objectattributes.attributable.Attributes;

public final class TransitRouterNetwork
implements Network {
    private static final Logger log = Logger.getLogger(TransitRouterNetwork.class);
    private final Map<Id<Link>, TransitRouterNetworkLink> links = new LinkedHashMap<Id<Link>, TransitRouterNetworkLink>();
    private final Map<Id<Node>, TransitRouterNetworkNode> nodes = new LinkedHashMap<Id<Node>, TransitRouterNetworkNode>();
    private QuadTree<TransitRouterNetworkNode> qtNodes = null;
    private long nextNodeId = 0L;
    private long nextLinkId = 0L;

    public TransitRouterNetworkNode createNode(TransitRouteStop stop, TransitRoute route, TransitLine line) {
        TransitRouterNetworkNode node = new TransitRouterNetworkNode(Id.create(this.nextNodeId++, Node.class), stop, route, line);
        this.nodes.put(node.getId(), node);
        return node;
    }

    public TransitRouterNetworkLink createLink(TransitRouterNetworkNode fromNode, TransitRouterNetworkNode toNode, TransitRoute route, TransitLine line) {
        TransitRouterNetworkLink link = new TransitRouterNetworkLink(Id.create(this.nextLinkId++, Link.class), fromNode, toNode, route, line);
        this.links.put(link.getId(), link);
        fromNode.outgoingLinks.put(link.getId(), link);
        toNode.ingoingLinks.put(link.getId(), link);
        return link;
    }

    public Map<Id<Node>, ? extends TransitRouterNetworkNode> getNodes() {
        return this.nodes;
    }

    public Map<Id<Link>, ? extends TransitRouterNetworkLink> getLinks() {
        return this.links;
    }

    public void finishInit() {
        double minX = Double.POSITIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        for (TransitRouterNetworkNode node : this.nodes.values()) {
            Coord c = node.stop.getStopFacility().getCoord();
            if (c.getX() < minX) {
                minX = c.getX();
            }
            if (c.getY() < minY) {
                minY = c.getY();
            }
            if (c.getX() > maxX) {
                maxX = c.getX();
            }
            if (!(c.getY() > maxY)) continue;
            maxY = c.getY();
        }
        QuadTree<TransitRouterNetworkNode> quadTree = new QuadTree<TransitRouterNetworkNode>(minX, minY, maxX, maxY);
        for (TransitRouterNetworkNode node : this.nodes.values()) {
            Coord c = node.stop.getStopFacility().getCoord();
            quadTree.put(c.getX(), c.getY(), node);
        }
        this.qtNodes = quadTree;
    }

    public Collection<TransitRouterNetworkNode> getNearestNodes(Coord coord, double distance) {
        return this.qtNodes.getDisk(coord.getX(), coord.getY(), distance);
    }

    public TransitRouterNetworkNode getNearestNode(Coord coord) {
        return this.qtNodes.getClosest(coord.getX(), coord.getY());
    }

    @Override
    public double getCapacityPeriod() {
        return 3600.0;
    }

    @Override
    public NetworkFactory getFactory() {
        return null;
    }

    @Override
    public double getEffectiveLaneWidth() {
        return 3.0;
    }

    @Override
    public void addNode(Node nn) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addLink(Link ll) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Link removeLink(Id<Link> linkId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Node removeNode(Id<Node> nodeId) {
        throw new UnsupportedOperationException();
    }

    public static TransitRouterNetwork createFromSchedule(TransitSchedule schedule, double maxBeelineWalkConnectionDistance) {
        log.info("start creating transit network");
        TransitRouterNetwork network = new TransitRouterNetwork();
        Counter linkCounter = new Counter(" link #");
        Counter nodeCounter = new Counter(" node #");
        for (TransitLine line : schedule.getTransitLines().values()) {
            for (TransitRoute route : line.getRoutes().values()) {
                TransitRouterNetworkNode prevNode = null;
                for (TransitRouteStop stop : route.getStops()) {
                    TransitRouterNetworkNode node = network.createNode(stop, route, line);
                    nodeCounter.incCounter();
                    if (prevNode != null) {
                        network.createLink(prevNode, node, route, line);
                        linkCounter.incCounter();
                    }
                    prevNode = node;
                }
            }
        }
        network.finishInit();
        log.info("add transfer links");
        LinkedList<Tuple<TransitRouterNetworkNode, TransitRouterNetworkNode>> toBeAdded = new LinkedList<Tuple<TransitRouterNetworkNode, TransitRouterNetworkNode>>();
        for (TransitRouterNetworkNode transitRouterNetworkNode : network.getNodes().values()) {
            if (transitRouterNetworkNode.getInLinks().size() <= 0) continue;
            for (TransitRouterNetworkNode node2 : network.getNearestNodes(transitRouterNetworkNode.stop.getStopFacility().getCoord(), maxBeelineWalkConnectionDistance)) {
                if (transitRouterNetworkNode == node2 || node2.getOutLinks().size() <= 0 || transitRouterNetworkNode.line == node2.line && transitRouterNetworkNode.stop.getStopFacility() == node2.stop.getStopFacility()) continue;
                toBeAdded.add(new Tuple<TransitRouterNetworkNode, TransitRouterNetworkNode>(transitRouterNetworkNode, node2));
            }
        }
        log.info(toBeAdded.size() + " transfer links to be added.");
        for (Tuple tuple : toBeAdded) {
            network.createLink((TransitRouterNetworkNode)tuple.getFirst(), (TransitRouterNetworkNode)tuple.getSecond(), null, null);
            linkCounter.incCounter();
        }
        log.info("transit router network statistics:");
        log.info(" # nodes: " + network.getNodes().size());
        log.info(" # links total:     " + network.getLinks().size());
        log.info(" # transfer links:  " + toBeAdded.size());
        return network;
    }

    @Override
    public void setCapacityPeriod(double capPeriod) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public void setEffectiveCellSize(double effectiveCellSize) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public void setEffectiveLaneWidth(double effectiveLaneWidth) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public void setName(String name) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public String getName() {
        throw new RuntimeException("not implemented");
    }

    @Override
    public double getEffectiveCellSize() {
        throw new RuntimeException("not implemented");
    }

    @Override
    public Attributes getAttributes() {
        throw new UnsupportedOperationException();
    }

    public static final class TransitRouterNetworkLink
    implements Link {
        public final TransitRouterNetworkNode fromNode;
        public final TransitRouterNetworkNode toNode;
        final TransitRoute route;
        final TransitLine line;
        final Id<Link> id;
        private final double length;

        public TransitRouterNetworkLink(Id<Link> id, TransitRouterNetworkNode fromNode, TransitRouterNetworkNode toNode, TransitRoute route, TransitLine line, double length) {
            this.id = id;
            this.fromNode = fromNode;
            this.toNode = toNode;
            this.route = route;
            this.line = line;
            this.length = length;
        }

        public TransitRouterNetworkLink(Id<Link> id, TransitRouterNetworkNode fromNode, TransitRouterNetworkNode toNode, TransitRoute route, TransitLine line) {
            this(id, fromNode, toNode, route, line, CoordUtils.calcEuclideanDistance(toNode.stop.getStopFacility().getCoord(), fromNode.stop.getStopFacility().getCoord()));
        }

        @Override
        public TransitRouterNetworkNode getFromNode() {
            return this.fromNode;
        }

        @Override
        public TransitRouterNetworkNode getToNode() {
            return this.toNode;
        }

        @Override
        public double getCapacity() {
            return this.getCapacity(Double.NEGATIVE_INFINITY);
        }

        @Override
        public double getCapacity(double time) {
            return 9999.0;
        }

        @Override
        public double getFreespeed() {
            return this.getFreespeed(Double.NEGATIVE_INFINITY);
        }

        @Override
        public double getFreespeed(double time) {
            return 10.0;
        }

        @Override
        public Id<Link> getId() {
            return this.id;
        }

        @Override
        public double getNumberOfLanes() {
            return this.getNumberOfLanes(Double.NEGATIVE_INFINITY);
        }

        @Override
        public double getNumberOfLanes(double time) {
            return 1.0;
        }

        @Override
        public double getLength() {
            return this.length;
        }

        @Override
        public void setCapacity(double capacity) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setFreespeed(double freespeed) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean setFromNode(Node node) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setNumberOfLanes(double lanes) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setLength(double length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean setToNode(Node node) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Coord getCoord() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<String> getAllowedModes() {
            return null;
        }

        @Override
        public void setAllowedModes(Set<String> modes) {
            throw new UnsupportedOperationException();
        }

        public TransitRoute getRoute() {
            return this.route;
        }

        public TransitLine getLine() {
            return this.line;
        }

        public String toString() {
            return "[" + this.id.toString() + " (" + this.getFromNode().id + " > " + this.getToNode().id + ")]";
        }

        @Override
        public double getFlowCapacityPerSec() {
            throw new RuntimeException("not implemented");
        }

        @Override
        public double getFlowCapacityPerSec(double time) {
            throw new RuntimeException("not implemented");
        }

        @Override
        public Attributes getAttributes() {
            throw new UnsupportedOperationException();
        }
    }

    public static final class TransitRouterNetworkNode
    implements Node {
        public final TransitRouteStop stop;
        public final TransitRoute route;
        public final TransitLine line;
        final Id<Node> id;
        final Map<Id<Link>, TransitRouterNetworkLink> ingoingLinks = new IdentifiableArrayMap<Link, TransitRouterNetworkLink>();
        final Map<Id<Link>, TransitRouterNetworkLink> outgoingLinks = new IdentifiableArrayMap<Link, TransitRouterNetworkLink>();

        public TransitRouterNetworkNode(Id<Node> id, TransitRouteStop stop, TransitRoute route, TransitLine line) {
            this.id = id;
            this.stop = stop;
            this.route = route;
            this.line = line;
        }

        @Override
        public Map<Id<Link>, ? extends Link> getInLinks() {
            return this.ingoingLinks;
        }

        @Override
        public Map<Id<Link>, ? extends Link> getOutLinks() {
            return this.outgoingLinks;
        }

        @Override
        public boolean addInLink(Link link) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addOutLink(Link link) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Coord getCoord() {
            return this.stop.getStopFacility().getCoord();
        }

        @Override
        public Id<Node> getId() {
            return this.id;
        }

        public TransitRouteStop getStop() {
            return this.stop;
        }

        public TransitRoute getRoute() {
            return this.route;
        }

        public TransitLine getLine() {
            return this.line;
        }

        public String toString() {
            return this.id.toString();
        }

        @Override
        public Link removeInLink(Id<Link> linkId) {
            throw new RuntimeException("not implemented");
        }

        @Override
        public Link removeOutLink(Id<Link> outLinkId) {
            throw new RuntimeException("not implemented");
        }

        @Override
        public void setCoord(Coord coord) {
            throw new RuntimeException("not implemented");
        }

        @Override
        public Attributes getAttributes() {
            throw new UnsupportedOperationException();
        }
    }
}

