/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.pt.router;

import org.matsim.api.core.v01.Coord;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.population.Person;
import org.matsim.core.router.util.TravelTime;
import org.matsim.core.utils.geometry.CoordUtils;
import org.matsim.pt.router.CustomDataManager;
import org.matsim.pt.router.PreparedTransitSchedule;
import org.matsim.pt.router.TransitRouterConfig;
import org.matsim.pt.router.TransitRouterNetwork;
import org.matsim.pt.router.TransitTravelDisutility;
import org.matsim.pt.transitSchedule.api.TransitRouteStop;
import org.matsim.vehicles.Vehicle;

public class TransitRouterNetworkTravelTimeAndDisutility
implements TravelTime,
TransitTravelDisutility {
    static final double MIDNIGHT = 86400.0;
    protected final TransitRouterConfig config;
    private Link previousLink = null;
    private double previousTime = Double.NaN;
    private double cachedTravelTime = Double.NaN;
    private final PreparedTransitSchedule preparedTransitSchedule;
    Link previousWaitLink;
    double previousWaitTime;
    double cachedVehArrivalTime;

    @Deprecated
    public TransitRouterNetworkTravelTimeAndDisutility(TransitRouterConfig config) {
        this(config, new PreparedTransitSchedule());
    }

    public TransitRouterNetworkTravelTimeAndDisutility(TransitRouterConfig config, PreparedTransitSchedule preparedTransitSchedule) {
        this.config = config;
        this.preparedTransitSchedule = preparedTransitSchedule;
    }

    @Override
    public double getLinkTravelDisutility(Link link, double time, Person person, Vehicle vehicle, CustomDataManager dataManager) {
        double cost;
        if (((TransitRouterNetwork.TransitRouterNetworkLink)link).getRoute() == null) {
            cost = this.defaultTransferCost(link, time, person, vehicle);
        } else {
            double offVehWaitTime = this.offVehicleWaitTime(link, time);
            double inVehTime = this.getLinkTravelTime(link, time, person, vehicle) - offVehWaitTime;
            cost = -inVehTime * this.config.getMarginalUtilityOfTravelTimePt_utl_s() - offVehWaitTime * this.config.getMarginalUtilityOfWaitingPt_utl_s() - link.getLength() * this.config.getMarginalUtilityOfTravelDistancePt_utl_m();
        }
        return cost;
    }

    protected double offVehicleWaitTime(Link link, double time) {
        double offVehWaitTime = 0.0;
        double nextVehArrivalTime = this.getVehArrivalTime(link, time);
        if (time < nextVehArrivalTime) {
            offVehWaitTime = nextVehArrivalTime - time;
        }
        return offVehWaitTime;
    }

    protected final double defaultTransferCost(Link link, double time, Person person, Vehicle vehicle) {
        double waittime;
        double transfertime = this.getLinkTravelTime(link, time, person, vehicle);
        double walktime = transfertime - (waittime = this.config.getAdditionalTransferTime());
        if (walktime < 0.0) {
            throw new RuntimeException("negative walk time; should not happen; needs to be repaired");
        }
        double walkDistance = link.getLength();
        double cost = -walktime * this.config.getMarginalUtilityOfTravelTimeWalk_utl_s() - walkDistance * this.config.getMarginalUtilityOfTravelDistanceWalk_utl_m() - waittime * this.config.getMarginalUtilityOfWaitingPt_utl_s() - this.config.getUtilityOfLineSwitch_utl();
        return cost;
    }

    @Override
    public double getLinkTravelTime(Link link, double time, Person person, Vehicle vehicle) {
        double time2;
        if (link == this.previousLink && time == this.previousTime) {
            return this.cachedTravelTime;
        }
        this.previousLink = link;
        this.previousTime = time;
        TransitRouterNetwork.TransitRouterNetworkLink wrapped = (TransitRouterNetwork.TransitRouterNetworkLink)link;
        TransitRouteStop fromStop = wrapped.fromNode.stop;
        TransitRouteStop toStop = wrapped.toNode.stop;
        if (wrapped.route != null) {
            double arrivalOffset;
            double bestDepartureTime = this.preparedTransitSchedule.getNextDepartureTime(wrapped.route, fromStop, time);
            double time22 = bestDepartureTime - time + ((arrivalOffset = toStop.getArrivalOffset() != Double.NEGATIVE_INFINITY ? toStop.getArrivalOffset() : toStop.getDepartureOffset()) - fromStop.getDepartureOffset());
            if (time22 < 0.0) {
                time22 += 86400.0;
            }
            this.cachedTravelTime = time22;
            return time22;
        }
        double distance = wrapped.getLength();
        this.cachedTravelTime = time2 = distance / this.config.getBeelineWalkSpeed() + this.config.getAdditionalTransferTime();
        return time2;
    }

    public double getVehArrivalTime(Link link, double now) {
        double vehArrivalTime;
        if (link == this.previousWaitLink && now == this.previousWaitTime) {
            return this.cachedVehArrivalTime;
        }
        this.previousWaitLink = link;
        this.previousWaitTime = now;
        TransitRouterNetwork.TransitRouterNetworkLink wrapped = (TransitRouterNetwork.TransitRouterNetworkLink)link;
        if (wrapped.getRoute() == null) {
            throw new RuntimeException("should not happen");
        }
        TransitRouteStop fromStop = wrapped.fromNode.stop;
        double nextDepartureTime = this.preparedTransitSchedule.getNextDepartureTime(wrapped.getRoute(), fromStop, now);
        double fromStopArrivalOffset = fromStop.getArrivalOffset() != Double.NEGATIVE_INFINITY ? fromStop.getArrivalOffset() : fromStop.getDepartureOffset();
        double vehWaitAtStopTime = fromStop.getDepartureOffset() - fromStopArrivalOffset;
        this.cachedVehArrivalTime = vehArrivalTime = nextDepartureTime - vehWaitAtStopTime;
        return vehArrivalTime;
    }

    @Override
    public double getWalkTravelDisutility(Person person, Coord coord, Coord toCoord) {
        double timeCost = -this.getWalkTravelTime(person, coord, toCoord) * this.config.getMarginalUtilityOfTravelTimeWalk_utl_s();
        double distanceCost = -CoordUtils.calcEuclideanDistance(coord, toCoord) * this.config.getBeelineDistanceFactor() * this.config.getMarginalUtilityOfTravelDistanceWalk_utl_m();
        return timeCost + distanceCost;
    }

    @Override
    public double getWalkTravelTime(Person person, Coord coord, Coord toCoord) {
        double distance = CoordUtils.calcEuclideanDistance(coord, toCoord);
        double initialTime = distance / this.config.getBeelineWalkSpeed();
        return initialTime;
    }
}

